/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.actuator.MicrometerMetricsRecorder;
import io.camunda.zeebe.spring.client.actuator.ZeebeClientHealthIndicator;
import io.camunda.zeebe.spring.client.configuration.MetricsDefaultConfiguration;
import io.camunda.zeebe.spring.client.configuration.condition.ConditionalOnCamundaClientEnabled;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@AutoConfigureBefore(value={MetricsDefaultConfiguration.class})
@ConditionalOnCamundaClientEnabled
@ConditionalOnClass(value={EndpointAutoConfiguration.class, MeterRegistry.class})
public class ZeebeActuatorConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MetricsRecorder micrometerMetricsRecorder(@Lazy MeterRegistry meterRegistry) {
        return new MicrometerMetricsRecorder(meterRegistry);
    }

    @Bean
    @ConditionalOnProperty(prefix="management.health.zeebe", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnMissingBean(name={"zeebeClientHealthIndicator"})
    public ZeebeClientHealthIndicator zeebeClientHealthIndicator(ZeebeClient client) {
        return new ZeebeClientHealthIndicator(client);
    }
}

