/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.properties;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.spring.client.annotation.Variable;
import io.camunda.zeebe.spring.client.annotation.VariablesAsType;
import io.camunda.zeebe.spring.client.annotation.customizer.ZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.bean.CopyNotNullBeanUtilsBean;
import io.camunda.zeebe.spring.client.bean.MethodInfo;
import io.camunda.zeebe.spring.client.bean.ParameterInfo;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class PropertyBasedZeebeWorkerValueCustomizer
implements ZeebeWorkerValueCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyBasedZeebeWorkerValueCustomizer.class);
    private static final CopyNotNullBeanUtilsBean BEAN_UTILS_BEAN = new CopyNotNullBeanUtilsBean();
    private final ZeebeClientConfigurationProperties zeebeClientConfigurationProperties;

    public PropertyBasedZeebeWorkerValueCustomizer(ZeebeClientConfigurationProperties zeebeClientConfigurationProperties) {
        this.zeebeClientConfigurationProperties = zeebeClientConfigurationProperties;
    }

    public void customize(ZeebeWorkerValue zeebeWorker) {
        this.applyDefaultWorkerName(zeebeWorker);
        this.applyDefaultJobWorkerType(zeebeWorker);
        this.applyDefaultJobWorkerTenantIds(zeebeWorker);
        this.applyFetchVariables(zeebeWorker);
        this.applyOverrides(zeebeWorker);
    }

    private void applyFetchVariables(ZeebeWorkerValue zeebeWorkerValue) {
        if (this.hasActivatedJobInjected(zeebeWorkerValue)) {
            LOG.debug("Worker '{}': ActivatedJob is injected, no variable filtering possible", (Object)zeebeWorkerValue.getName());
        } else if (zeebeWorkerValue.isForceFetchAllVariables()) {
            LOG.debug("Worker '{}': Force fetch all variables is enabled", (Object)zeebeWorkerValue.getName());
            zeebeWorkerValue.setFetchVariables(new String[0]);
        } else {
            HashSet<String> variables = new HashSet<String>();
            if (zeebeWorkerValue.getFetchVariables() != null) {
                variables.addAll(Arrays.asList(zeebeWorkerValue.getFetchVariables()));
            }
            variables.addAll(this.readZeebeVariableParameters(zeebeWorkerValue.getMethodInfo()).stream().map(this::extractVariableName).collect(Collectors.toList()));
            variables.addAll(this.readVariablesAsTypeParameters(zeebeWorkerValue.getMethodInfo()));
            zeebeWorkerValue.setFetchVariables(variables.toArray(new String[0]));
            LOG.debug("Worker '{}': Fetching only required variables {}", (Object)zeebeWorkerValue.getName(), variables);
        }
    }

    private boolean hasActivatedJobInjected(ZeebeWorkerValue zeebeWorkerValue) {
        return zeebeWorkerValue.getMethodInfo().getParameters().stream().anyMatch(p -> p.getParameterInfo().getType().isAssignableFrom(ActivatedJob.class));
    }

    private List<ParameterInfo> readZeebeVariableParameters(MethodInfo methodInfo) {
        return methodInfo.getParametersFilteredByAnnotation(Variable.class);
    }

    private String extractVariableName(ParameterInfo parameterInfo) {
        Variable variableAnnotation = parameterInfo.getParameterInfo().getAnnotation(Variable.class);
        if (variableAnnotation != null && !"$NULL$".equals(variableAnnotation.name())) {
            return variableAnnotation.name();
        }
        return parameterInfo.getParameterName();
    }

    private List<String> readVariablesAsTypeParameters(MethodInfo methodInfo) {
        ArrayList<String> result = new ArrayList<String>();
        List parameters = methodInfo.getParametersFilteredByAnnotation(VariablesAsType.class);
        parameters.forEach(pi -> ReflectionUtils.doWithFields(pi.getParameterInfo().getType(), f -> result.add(this.extractFieldName(f))));
        return result;
    }

    private String extractFieldName(Field field) {
        String value;
        if (field.isAnnotationPresent(JsonProperty.class) && StringUtils.isNotBlank((CharSequence)(value = field.getAnnotation(JsonProperty.class).value()))) {
            return value;
        }
        return field.getName();
    }

    private void applyOverrides(ZeebeWorkerValue zeebeWorker) {
        String workerType;
        Map<String, ZeebeWorkerValue> workerConfigurationMap = this.zeebeClientConfigurationProperties.getWorker().getOverride();
        if (workerConfigurationMap.containsKey(workerType = zeebeWorker.getType())) {
            ZeebeWorkerValue zeebeWorkerValue = workerConfigurationMap.get(workerType);
            LOG.debug("Worker '{}': Applying overrides {}", (Object)workerType, (Object)zeebeWorkerValue);
            try {
                BEAN_UTILS_BEAN.copyProperties((Object)zeebeWorker, (Object)zeebeWorkerValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error while copying properties from " + String.valueOf(zeebeWorkerValue) + " to " + String.valueOf(zeebeWorker), e);
            }
        }
    }

    private void applyDefaultWorkerName(ZeebeWorkerValue zeebeWorker) {
        String defaultJobWorkerName = this.zeebeClientConfigurationProperties.getDefaultJobWorkerName();
        if (StringUtils.isBlank((CharSequence)zeebeWorker.getName())) {
            if (StringUtils.isNotBlank((CharSequence)defaultJobWorkerName)) {
                LOG.debug("Worker '{}': Setting name to default {}", (Object)zeebeWorker.getName(), (Object)defaultJobWorkerName);
                zeebeWorker.setName(defaultJobWorkerName);
            } else {
                String generatedJobWorkerName = zeebeWorker.getMethodInfo().getBeanName() + "#" + zeebeWorker.getMethodInfo().getMethodName();
                LOG.debug("Worker '{}': Setting name to generated {}", (Object)zeebeWorker.getName(), (Object)generatedJobWorkerName);
                zeebeWorker.setName(generatedJobWorkerName);
            }
        }
    }

    private void applyDefaultJobWorkerType(ZeebeWorkerValue zeebeWorker) {
        String defaultJobWorkerType = this.zeebeClientConfigurationProperties.getDefaultJobWorkerType();
        if (StringUtils.isBlank((CharSequence)zeebeWorker.getType())) {
            if (StringUtils.isNotBlank((CharSequence)defaultJobWorkerType)) {
                LOG.debug("Worker '{}': Setting type to default {}", (Object)zeebeWorker.getName(), (Object)defaultJobWorkerType);
                zeebeWorker.setType(defaultJobWorkerType);
            } else {
                String generatedJobWorkerType = zeebeWorker.getMethodInfo().getMethodName();
                LOG.debug("Worker '{}': Setting type to generated {}", (Object)zeebeWorker.getName(), (Object)generatedJobWorkerType);
                zeebeWorker.setType(generatedJobWorkerType);
            }
        }
    }

    private void applyDefaultJobWorkerTenantIds(ZeebeWorkerValue zeebeWorker) {
        HashSet<String> tenantIds = new HashSet<String>(this.zeebeClientConfigurationProperties.getDefaultJobWorkerTenantIds());
        if (zeebeWorker.getTenantIds() != null) {
            tenantIds.addAll(zeebeWorker.getTenantIds());
        }
        if (!tenantIds.isEmpty()) {
            LOG.debug("Worker '{}': Setting tenantIds to {}", (Object)zeebeWorker.getName(), tenantIds);
            zeebeWorker.setTenantIds(new ArrayList<String>(tenantIds));
        }
    }
}

