/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeClientImpl;
import io.camunda.zeebe.client.impl.util.ExecutorResource;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.spring.client.configuration.ExecutorServiceConfiguration;
import io.camunda.zeebe.spring.client.configuration.ZeebeActuatorConfiguration;
import io.camunda.zeebe.spring.client.configuration.ZeebeClientAllAutoConfiguration;
import io.camunda.zeebe.spring.client.configuration.ZeebeClientConfigurationSpringImpl;
import io.camunda.zeebe.spring.client.configuration.condition.ConditionalOnCamundaClientEnabled;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.properties.CommonConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.camunda.zeebe.spring.client.testsupport.SpringZeebeTestContext;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnCamundaClientEnabled
@ConditionalOnMissingBean(value={SpringZeebeTestContext.class})
@ImportAutoConfiguration(value={ExecutorServiceConfiguration.class, ZeebeActuatorConfiguration.class})
@AutoConfigureBefore(value={ZeebeClientAllAutoConfiguration.class})
public class ZeebeClientProdAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeClientProdAutoConfiguration.class);

    @Bean
    public ZeebeClientConfigurationSpringImpl zeebeClientConfiguration(ZeebeClientConfigurationProperties properties, CommonConfigurationProperties commonConfigurationProperties, JsonMapper jsonMapper, List<ClientInterceptor> interceptors, ZeebeClientExecutorService zeebeClientExecutorService) {
        return new ZeebeClientConfigurationSpringImpl(properties, commonConfigurationProperties, jsonMapper, interceptors, zeebeClientExecutorService){};
    }

    @Bean(destroyMethod="close")
    public ZeebeClient zeebeClient(ZeebeClientConfiguration configuration) {
        LOG.info("Creating ZeebeClient using ZeebeClientConfiguration [" + String.valueOf(configuration) + "]");
        ScheduledExecutorService jobWorkerExecutor = configuration.jobWorkerExecutor();
        if (jobWorkerExecutor != null) {
            ManagedChannel managedChannel = ZeebeClientImpl.buildChannel((ZeebeClientConfiguration)configuration);
            GatewayGrpc.GatewayStub gatewayStub = ZeebeClientImpl.buildGatewayStub((ManagedChannel)managedChannel, (ZeebeClientConfiguration)configuration);
            ExecutorResource executorResource = new ExecutorResource(jobWorkerExecutor, configuration.ownsJobWorkerExecutor());
            return new ZeebeClientImpl(configuration, managedChannel, gatewayStub, executorResource);
        }
        return new ZeebeClientImpl(configuration);
    }
}

