/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.tomcat;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

public class URLRedirectFilter
implements Filter {
    private static final String WEBAPP_PATH = "/webapp";
    private final Pattern redirectPattern;
    private final String redirectPath;

    public URLRedirectFilter(String regex, String redirectPath) {
        this.redirectPattern = Pattern.compile(regex);
        this.redirectPath = redirectPath;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestURI;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String originalRequestURI = requestURI = httpRequest.getRequestURI();
        String contextPath = httpRequest.getContextPath();
        if (!contextPath.isEmpty() && requestURI.startsWith(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        if (requestURI.isEmpty()) {
            httpResponse.sendRedirect(this.redirectPath);
            return;
        }
        if ("/".equals(requestURI)) {
            chain.doFilter(request, response);
            return;
        }
        String staticRequestPath = requestURI;
        String staticFilePath = WEBAPP_PATH + staticRequestPath;
        InputStream fileStream = this.getClass().getResourceAsStream(staticFilePath);
        if (fileStream != null) {
            chain.doFilter(request, response);
            return;
        }
        if (this.redirectPattern.matcher(requestURI).matches()) {
            httpResponse.sendRedirect(this.redirectPath);
            return;
        }
        chain.doFilter(request, response);
    }
}

