/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.tomcat;

import io.camunda.optimize.tomcat.ExternalResourcesUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class CCSaasRequestAdjustmentFilter
implements Filter {
    private final String clusterId;
    private ServletContext servletContext;

    public CCSaasRequestAdjustmentFilter(String clusterId) {
        this.clusterId = clusterId == null ? "" : clusterId;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean shallForward = false;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = httpRequest.getRequestURI();
        if (requestURI.equals(this.clusterIdPath())) {
            httpResponse.sendRedirect(requestURI + "/");
            return;
        }
        if (ExternalResourcesUtil.shouldServeStaticResource(httpRequest, this.clusterId)) {
            ExternalResourcesUtil.serveStaticResource(httpRequest, httpResponse, this.servletContext, this.clusterId);
            return;
        }
        if (!this.clusterId.isEmpty() && requestURI.startsWith(this.clusterIdPath())) {
            requestURI = requestURI.substring(this.clusterIdPath().length());
            shallForward = true;
        }
        if (requestURI.startsWith("/external/api/")) {
            requestURI = requestURI.replaceFirst("/external/api/", "/api/external/");
            shallForward = true;
        }
        if (shallForward) {
            RequestDispatcher dispatcher = request.getRequestDispatcher(requestURI);
            dispatcher.forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    private String clusterIdPath() {
        if (this.clusterId.isEmpty()) {
            return "";
        }
        return "/" + this.clusterId;
    }
}

