/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.metadata.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotUtil {
    public static final String REPOSITORY_MISSING_EXCEPTION_TYPE = "repository_missing_exception";
    public static final String SNAPSHOT_MISSING_EXCEPTION_TYPE = "snapshot_missing_exception";
    private static final String COMPONENT_PREFIX = "camunda_optimize_";
    private static final String SNAPSHOT_PREFIX = "{componentPrefix}{backupId}_";
    private static final String SNAPSHOT_1_NAME_TEMPLATE = "{prefix}{version}_part_1_of_2";
    private static final String SNAPSHOT_2_NAME_TEMPLATE = "{prefix}{version}_part_2_of_2";
    private static final String PREFIX_PLACEHOLDER = "{prefix}";
    private static final String COMPONENT_PREFIX_PLACEHOLDER = "{componentPrefix}";
    private static final String ID_PLACEHOLDER = "{backupId}";
    private static final String VERSION_PLACEHOLDER = "{version}";
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotUtil.class);

    public static String getSnapshotNameForImportIndices(Long backupId) {
        return SnapshotUtil.getSnapshotName(SNAPSHOT_1_NAME_TEMPLATE, backupId);
    }

    public static String getSnapshotNameForNonImportIndices(Long backupId) {
        return SnapshotUtil.getSnapshotName(SNAPSHOT_2_NAME_TEMPLATE, backupId);
    }

    public static String getSnapshotPrefixWithBackupId(Long backupId) {
        return SNAPSHOT_PREFIX.replace(COMPONENT_PREFIX_PLACEHOLDER, COMPONENT_PREFIX).replace(ID_PLACEHOLDER, String.valueOf(backupId));
    }

    public static Long getBackupIdFromSnapshotName(String snapshotName) {
        Pattern pattern = Pattern.compile("^camunda_optimize_(\\d+)_.*$");
        Matcher matcher = pattern.matcher(snapshotName);
        if (matcher.find()) {
            String numberStr = matcher.group(1);
            try {
                return Long.parseLong(numberStr);
            }
            catch (NumberFormatException e) {
                String msg = String.format("Cannot retrieve backupID from snapshot [%s] because the found backupID is not a valid integer.", snapshotName);
                LOG.error(msg);
                throw new OptimizeRuntimeException(msg, (Throwable)e);
            }
        }
        String msg = String.format("No backupID found in snapshot [%s].", snapshotName);
        LOG.error(msg);
        throw new OptimizeRuntimeException(msg);
    }

    public static String[] getAllWildcardedSnapshotNamesForBackupId(Long backupId) {
        return new String[]{SnapshotUtil.getSnapshotNameWithVersionWildcard(SNAPSHOT_1_NAME_TEMPLATE, backupId), SnapshotUtil.getSnapshotNameWithVersionWildcard(SNAPSHOT_2_NAME_TEMPLATE, backupId)};
    }

    public static String[] getAllWildcardedSnapshotNamesForWildcardedBackupId() {
        return new String[]{SNAPSHOT_1_NAME_TEMPLATE.replace(PREFIX_PLACEHOLDER, SNAPSHOT_PREFIX.replace(COMPONENT_PREFIX_PLACEHOLDER, COMPONENT_PREFIX).replace(ID_PLACEHOLDER, "*")).replace(VERSION_PLACEHOLDER, "*"), SNAPSHOT_2_NAME_TEMPLATE.replace(PREFIX_PLACEHOLDER, SNAPSHOT_PREFIX.replace(COMPONENT_PREFIX_PLACEHOLDER, COMPONENT_PREFIX).replace(ID_PLACEHOLDER, "*")).replace(VERSION_PLACEHOLDER, "*")};
    }

    private static String getSnapshotNameWithVersionWildcard(String snapshotNameTemplate, Long backupId) {
        return snapshotNameTemplate.replace(PREFIX_PLACEHOLDER, SnapshotUtil.getSnapshotPrefixWithBackupId(backupId)).replace(VERSION_PLACEHOLDER, "*");
    }

    private static String getSnapshotName(String snapshotNameTemplate, Long backupId) {
        return snapshotNameTemplate.replace(PREFIX_PLACEHOLDER, SnapshotUtil.getSnapshotPrefixWithBackupId(backupId)).replace(VERSION_PLACEHOLDER, Version.VERSION);
    }
}

