/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RootUrlGenerator {
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final Logger LOG = LoggerFactory.getLogger(RootUrlGenerator.class);
    private final ConfigurationService configurationService;

    public RootUrlGenerator(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public String getRootUrl() {
        Optional containerAccessUrl = this.configurationService.getContainerAccessUrl();
        if (containerAccessUrl.isPresent()) {
            return (String)containerAccessUrl.get();
        }
        Optional containerHttpPort = this.configurationService.getContainerHttpPort();
        String httpPrefix = containerHttpPort.map(p -> HTTP_PREFIX).orElse(HTTPS_PREFIX);
        Integer port = containerHttpPort.orElse(this.configurationService.getContainerHttpsPort());
        return httpPrefix + this.configurationService.getContainerHost() + ":" + port + this.configurationService.getContextPath().orElse("");
    }
}

