/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportItemDto;
import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.DistributedByType;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.process_part.ProcessPartDto;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessVisualization;
import io.camunda.optimize.dto.optimize.query.report.single.process.distributed.ProcessDistributedByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.distributed.ProcessReportDistributedByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.ProcessGroupByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.ProcessGroupByType;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.ProcessViewDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.ProcessViewEntity;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.report.interpreter.util.ProcessDistributedByCreator;
import io.camunda.optimize.service.db.report.interpreter.util.ProcessGroupByDtoCreator;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessReportDataBuilderHelper {
    private List<ReportDataDefinitionDto> definitions = Collections.singletonList(new ReportDataDefinitionDto());
    private ProcessViewEntity viewEntity = null;
    private ViewProperty viewProperty = ViewProperty.RAW_DATA;
    private ProcessGroupByType groupByType = ProcessGroupByType.NONE;
    private DistributedByType distributedByType = DistributedByType.NONE;
    private ProcessVisualization visualization = ProcessVisualization.TABLE;
    private AggregateByDateUnit groupByDateInterval;
    private AggregateByDateUnit distributeByDateInterval;
    private String variableName;
    private VariableType variableType;
    private String processPartStart;
    private String processPartEnd;
    private ProcessPartDto processPart = null;

    public ProcessReportDataDto build() {
        ProcessGroupByDto<?> groupBy = this.createGroupBy();
        ProcessReportDistributedByDto<?> distributedBy = this.createDistributedBy();
        ProcessViewDto view = new ProcessViewDto(this.viewEntity, this.viewProperty);
        if (this.processPartStart != null && this.processPartEnd != null) {
            this.processPart = ProcessReportDataBuilderHelper.createProcessPart(this.processPartStart, this.processPartEnd);
        }
        ProcessReportDataDto reportData = ((ProcessReportDataDto.ProcessReportDataDtoBuilder)ProcessReportDataDto.builder().definitions(this.definitions)).visualization(this.visualization).view(view).groupBy(groupBy).distributedBy(distributedBy).build();
        reportData.getConfiguration().setProcessPart(this.processPart);
        return reportData;
    }

    private ProcessGroupByDto<?> createGroupBy() {
        switch (this.groupByType) {
            case NONE: {
                return ProcessGroupByDtoCreator.createGroupByNone();
            }
            case VARIABLE: {
                return ProcessGroupByDtoCreator.createGroupByVariable(this.variableName, this.variableType);
            }
            case START_DATE: {
                return ProcessGroupByDtoCreator.createGroupByStartDateDto(this.groupByDateInterval);
            }
            case END_DATE: {
                return ProcessGroupByDtoCreator.createGroupByEndDateDto(this.groupByDateInterval);
            }
            case RUNNING_DATE: {
                return ProcessGroupByDtoCreator.createGroupByRunningDateDto(this.groupByDateInterval);
            }
            case ASSIGNEE: {
                return ProcessGroupByDtoCreator.createGroupByAssignee();
            }
            case CANDIDATE_GROUP: {
                return ProcessGroupByDtoCreator.createGroupByCandidateGroup();
            }
            case FLOW_NODES: {
                return ProcessGroupByDtoCreator.createGroupByFlowNode();
            }
            case USER_TASKS: {
                return ProcessGroupByDtoCreator.createGroupByUserTasks();
            }
            case DURATION: {
                return ProcessGroupByDtoCreator.createGroupByDuration();
            }
        }
        throw new OptimizeRuntimeException("Unsupported groupBy type:" + String.valueOf(this.groupByType));
    }

    private ProcessReportDistributedByDto<?> createDistributedBy() {
        switch (this.distributedByType) {
            case NONE: {
                return ProcessDistributedByCreator.createDistributedByNone();
            }
            case ASSIGNEE: {
                return ProcessDistributedByCreator.createDistributedByAssignee();
            }
            case CANDIDATE_GROUP: {
                return ProcessDistributedByCreator.createDistributedByCandidateGroup();
            }
            case FLOW_NODE: {
                return ProcessDistributedByCreator.createDistributedByFlowNode();
            }
            case USER_TASK: {
                return ProcessDistributedByCreator.createDistributedByUserTasks();
            }
            case VARIABLE: {
                return ProcessDistributedByCreator.createDistributedByVariable(this.variableName, this.variableType);
            }
            case START_DATE: {
                return ProcessDistributedByCreator.createDistributedByStartDateDto(this.distributeByDateInterval);
            }
            case END_DATE: {
                return ProcessDistributedByCreator.createDistributedByEndDateDto(this.distributeByDateInterval);
            }
            case PROCESS: {
                return new ProcessDistributedByDto();
            }
        }
        throw new OptimizeRuntimeException("Unsupported distributedBy type:" + String.valueOf(this.distributedByType));
    }

    public ProcessReportDataBuilderHelper definitions(List<ReportDataDefinitionDto> definitions) {
        this.definitions = definitions;
        return this;
    }

    public ProcessReportDataBuilderHelper processDefinitionKey(String processDefinitionKey) {
        this.definitions.get(0).setKey(processDefinitionKey);
        return this;
    }

    public ProcessReportDataBuilderHelper processDefinitionVersions(List<String> processDefinitionVersions) {
        this.definitions.get(0).setVersions(processDefinitionVersions);
        return this;
    }

    public ProcessReportDataBuilderHelper processDefinitionVersion(String processDefinitionVersion) {
        this.definitions.get(0).setVersion(processDefinitionVersion);
        return this;
    }

    public ProcessReportDataBuilderHelper viewEntity(ProcessViewEntity viewEntity) {
        this.viewEntity = viewEntity;
        return this;
    }

    public ProcessReportDataBuilderHelper viewProperty(ViewProperty viewProperty) {
        this.viewProperty = viewProperty;
        return this;
    }

    public ProcessReportDataBuilderHelper groupByType(ProcessGroupByType groupByType) {
        this.groupByType = groupByType;
        return this;
    }

    public ProcessReportDataBuilderHelper distributedByType(DistributedByType distributedByType) {
        this.distributedByType = distributedByType;
        return this;
    }

    public ProcessReportDataBuilderHelper visualization(ProcessVisualization visualization) {
        this.visualization = visualization;
        return this;
    }

    public ProcessReportDataBuilderHelper groupByDateInterval(AggregateByDateUnit groupByDateInterval) {
        this.groupByDateInterval = groupByDateInterval;
        return this;
    }

    public ProcessReportDataBuilderHelper distributeByDateInterval(AggregateByDateUnit distributeByDateInterval) {
        this.distributeByDateInterval = distributeByDateInterval;
        return this;
    }

    public ProcessReportDataBuilderHelper variableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    public ProcessReportDataBuilderHelper variableType(VariableType variableType) {
        this.variableType = variableType;
        return this;
    }

    public ProcessReportDataBuilderHelper processPartStart(String processPartStart) {
        this.processPartStart = processPartStart;
        return this;
    }

    public ProcessReportDataBuilderHelper processPartEnd(String processPartEnd) {
        this.processPartEnd = processPartEnd;
        return this;
    }

    public static CombinedReportDataDto createCombinedReportData(String ... reportIds) {
        CombinedReportDataDto combinedReportDataDto = new CombinedReportDataDto();
        combinedReportDataDto.setReports(Arrays.stream(reportIds).map(CombinedReportItemDto::new).collect(Collectors.toList()));
        return combinedReportDataDto;
    }

    private static ProcessPartDto createProcessPart(String start, String end) {
        ProcessPartDto processPartDto = new ProcessPartDto();
        processPartDto.setStart(start);
        processPartDto.setEnd(end);
        return processPartDto;
    }
}

