/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.util.DefinitionQueryUtilES;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import java.util.List;

public class NestedDefinitionQueryBuilder {
    private final String nestedField;
    private final String definitionKeyField;
    private final String versionField;
    private final String tenantIdField;

    public NestedDefinitionQueryBuilder(String nestedField, String definitionKeyField, String versionField, String tenantIdField) {
        this.nestedField = nestedField;
        this.definitionKeyField = definitionKeyField;
        this.versionField = versionField;
        this.tenantIdField = tenantIdField;
    }

    public Query.Builder createNestedDocDefinitionQueryBuilder(String definitionKey, List<String> definitionVersions, List<String> tenantIds, DefinitionService definitionService) {
        Query.Builder builder = new Query.Builder();
        BoolQuery.Builder queryBuilder = new BoolQuery.Builder();
        queryBuilder.filter(DefinitionQueryUtilES.createTenantIdQuery(this.nestedFieldReference(this.tenantIdField), tenantIds), new Query[0]);
        queryBuilder.filter(f -> f.term(t -> t.field(this.nestedFieldReference(this.definitionKeyField)).value(definitionKey)));
        if (DefinitionVersionHandlingUtil.isDefinitionVersionSetToLatest(definitionVersions)) {
            queryBuilder.filter(f -> f.terms(t -> t.field(this.nestedFieldReference(this.versionField)).terms(tt -> tt.value(List.of(FieldValue.of((String)definitionService.getLatestVersionToKey(DefinitionType.PROCESS, definitionKey)))))));
        } else if (!DefinitionVersionHandlingUtil.isDefinitionVersionSetToAll(definitionVersions)) {
            queryBuilder.filter(f -> f.terms(t -> t.field(this.nestedFieldReference(this.versionField)).terms(tt -> tt.value(definitionVersions.stream().map(FieldValue::of).toList()))));
        } else if (definitionVersions.isEmpty()) {
            queryBuilder.mustNot(m -> m.matchAll(r -> r));
        }
        builder.bool(queryBuilder.build());
        return builder;
    }

    private String nestedFieldReference(String fieldName) {
        return this.nestedField + "." + fieldName;
    }
}

