/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.Input;
import org.camunda.bpm.model.dmn.instance.NamedElement;
import org.camunda.bpm.model.dmn.instance.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DmnModelUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DmnModelUtil.class);

    private DmnModelUtil() {
    }

    public static DmnModelInstance parseDmnModel(String dmn10Xml) {
        DmnModelInstance dmnModelInstance;
        ByteArrayInputStream stream = new ByteArrayInputStream(dmn10Xml.getBytes());
        try {
            dmnModelInstance = Dmn.readModelFromStream((InputStream)stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OptimizeRuntimeException("Failed reading model", (Throwable)e);
            }
        }
        stream.close();
        return dmnModelInstance;
    }

    public static Optional<String> extractDecisionDefinitionName(String definitionKey, String xml) {
        try {
            DmnModelInstance dmnModelInstance = DmnModelUtil.parseDmnModel(xml);
            Collection decisions = dmnModelInstance.getModelElementsByType(Decision.class);
            return decisions.stream().filter(decision -> decision.getId().equals(definitionKey)).map(NamedElement::getName).findFirst();
        }
        catch (Exception exc) {
            LOG.warn("Failed parsing the DMN xml.", (Throwable)exc);
            return Optional.empty();
        }
    }

    public static List<DecisionVariableNameResponseDto> extractInputVariables(DmnModelInstance model, String decisionKey) {
        if (decisionKey == null) {
            throw new IllegalArgumentException("decisionKey must not be null");
        }
        return DmnModelUtil.extractVariables(model, decisionKey, DmnModelUtil::extractInputVariablesFromDecision);
    }

    public static List<DecisionVariableNameResponseDto> extractOutputVariables(DmnModelInstance model, String decisionKey) {
        if (decisionKey == null) {
            throw new IllegalArgumentException("decisionKey must not be null");
        }
        return DmnModelUtil.extractVariables(model, decisionKey, DmnModelUtil::extractOutputVariablesFromDecision);
    }

    private static List<DecisionVariableNameResponseDto> extractVariables(DmnModelInstance model, String decisionKey, VariableExtractionFunction extractVariables) {
        if (decisionKey == null) {
            throw new IllegalArgumentException("decisionKey must not be null");
        }
        return model.getModelElementsByType(Decision.class).stream().filter(decision -> Objects.equals(decision.getId(), decisionKey)).findFirst().map(decision -> {
            Collection decisionTables = decision.getChildElementsByType(DecisionTable.class);
            if (decisionTables.size() < 1) {
                LOG.warn("Found decision without tables, which is not supported!");
                return new ArrayList();
            }
            if (decisionTables.size() > 1) {
                LOG.warn("Found decision with multiple tables. Supported is only one!");
                return new ArrayList();
            }
            DecisionTable firstDecisionTable = (DecisionTable)decisionTables.iterator().next();
            return extractVariables.extract(firstDecisionTable, decisionKey);
        }).orElse(new ArrayList());
    }

    private static List<DecisionVariableNameResponseDto> extractInputVariablesFromDecision(DecisionTable decision, String xmlDecisionKey) {
        ArrayList<DecisionVariableNameResponseDto> inputVariableList = new ArrayList<DecisionVariableNameResponseDto>();
        for (Input node : decision.getChildElementsByType(Input.class)) {
            DecisionVariableNameResponseDto variableNameDto = new DecisionVariableNameResponseDto();
            variableNameDto.setId(node.getId());
            variableNameDto.setName(node.getLabel());
            String id = node.getInputExpression().getTypeRef();
            if (id == null) {
                LOG.warn("Found decision input with id {} without a type on decision with key {}, will default to String", (Object)node.getId(), (Object)xmlDecisionKey);
                variableNameDto.setType(VariableType.STRING);
            } else {
                variableNameDto.setType(VariableType.getTypeForId((String)id));
            }
            inputVariableList.add(variableNameDto);
        }
        return inputVariableList;
    }

    private static List<DecisionVariableNameResponseDto> extractOutputVariablesFromDecision(DecisionTable decision, String xmlDecisionKey) {
        ArrayList<DecisionVariableNameResponseDto> outputVariableList = new ArrayList<DecisionVariableNameResponseDto>();
        for (Output node : decision.getChildElementsByType(Output.class)) {
            DecisionVariableNameResponseDto variableNameDto = new DecisionVariableNameResponseDto();
            variableNameDto.setId(node.getId());
            variableNameDto.setName(node.getLabel());
            String id = node.getTypeRef();
            if (id == null) {
                LOG.warn("Found decision output with id {} without a type on decision with key {}, will default to String", (Object)node.getId(), (Object)xmlDecisionKey);
                variableNameDto.setType(VariableType.STRING);
            } else {
                variableNameDto.setType(VariableType.getTypeForId((String)id));
            }
            outputVariableList.add(variableNameDto);
        }
        return outputVariableList;
    }

    private static interface VariableExtractionFunction {
        public List<DecisionVariableNameResponseDto> extract(DecisionTable var1, String var2);
    }
}

