/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import com.google.common.collect.ImmutableList;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public final class DefinitionVersionHandlingUtil {
    private DefinitionVersionHandlingUtil() {
    }

    public static String convertToLatestParticularVersion(String processDefinitionVersion, Supplier<String> latestVersionSupplier) {
        return DefinitionVersionHandlingUtil.convertToLatestParticularVersion((List<String>)ImmutableList.of((Object)processDefinitionVersion), latestVersionSupplier);
    }

    public static String convertToLatestParticularVersion(List<String> definitionVersions, Supplier<String> latestVersionSupplier) {
        if (definitionVersions == null) {
            throw new IllegalArgumentException("definitionVersions cannot be null");
        }
        if (latestVersionSupplier == null) {
            throw new IllegalArgumentException("latestVersionSupplier cannot be null");
        }
        boolean isDefinitionVersionSetToAllOrLatest = definitionVersions.stream().anyMatch(version -> "all".equalsIgnoreCase((String)version) || "latest".equalsIgnoreCase((String)version));
        if (isDefinitionVersionSetToAllOrLatest) {
            return latestVersionSupplier.get();
        }
        try {
            return definitionVersions.stream().filter(StringUtils::isNumeric).map(Integer::parseInt).max(Integer::compareTo).map(Object::toString).orElse(DefinitionVersionHandlingUtil.getLastEntryInList(definitionVersions));
        }
        catch (NumberFormatException exception) {
            throw new OptimizeRuntimeException("Cannot determine latest version for definition");
        }
    }

    private static String getLastEntryInList(List<String> processDefinitionVersions) {
        return processDefinitionVersions.get(processDefinitionVersions.size() - 1);
    }

    public static boolean isDefinitionVersionSetToAll(List<String> definitionVersions) {
        return definitionVersions.stream().anyMatch("all"::equalsIgnoreCase);
    }

    public static boolean isDefinitionVersionSetToLatest(List<String> definitionVersions) {
        return definitionVersions.stream().anyMatch("latest"::equalsIgnoreCase);
    }

    public static boolean isDefinitionVersionSetToAllOrLatest(String definitionVersion) {
        return DefinitionVersionHandlingUtil.isDefinitionVersionSetToAllOrLatest(Collections.singletonList(definitionVersion));
    }

    public static boolean isDefinitionVersionSetToAllOrLatest(List<String> definitionVersions) {
        return definitionVersions.stream().anyMatch(v -> "all".equalsIgnoreCase((String)v) || "latest".equalsIgnoreCase((String)v));
    }
}

