/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.FlowNodeDataDto;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.CallableElement;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.IdentifiableBpmnElement;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.UserTask;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BpmnModelUtil {
    public static final String BPMN_ELEMENT_ATTRIBUTE = "bpmnElement";
    public static final String IS_EXPANDED_ATTRIBUTE = "isExpanded";
    private static final Logger LOG = LoggerFactory.getLogger(BpmnModelUtil.class);

    private BpmnModelUtil() {
    }

    public static BpmnModelInstance parseBpmnModel(String bpmn20Xml) {
        BpmnModelInstance bpmnModelInstance;
        ByteArrayInputStream stream = new ByteArrayInputStream(bpmn20Xml.getBytes());
        try {
            bpmnModelInstance = Bpmn.readModelFromStream((InputStream)stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OptimizeRuntimeException("Failed reading model", (Throwable)e);
            }
        }
        stream.close();
        return bpmnModelInstance;
    }

    public static List<FlowNodeDataDto> extractFlowNodeData(String bpmn20Xml) {
        return BpmnModelUtil.extractFlowNodeData(BpmnModelUtil.parseBpmnModel(bpmn20Xml));
    }

    public static Map<String, String> extractUserTaskNames(String bpmn20Xml) {
        return BpmnModelUtil.extractUserTaskNames(BpmnModelUtil.parseBpmnModel(bpmn20Xml));
    }

    public static Optional<String> extractProcessDefinitionName(String definitionKey, String xml) {
        try {
            BpmnModelInstance bpmnModelInstance = BpmnModelUtil.parseBpmnModel(xml);
            Collection processes = bpmnModelInstance.getModelElementsByType(Process.class);
            return processes.stream().filter(process -> process.getId().equals(definitionKey)).map(CallableElement::getName).filter(Objects::nonNull).findFirst();
        }
        catch (Exception exc) {
            LOG.warn("Failed parsing the BPMN xml.", (Throwable)exc);
            return Optional.empty();
        }
    }

    public static Map<String, String> extractUserTaskNames(BpmnModelInstance model) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (UserTask userTask : model.getModelElementsByType(UserTask.class)) {
            result.put(userTask.getId(), userTask.getName());
        }
        return result;
    }

    public static List<FlowNodeDataDto> extractFlowNodeData(BpmnModelInstance model) {
        ArrayList<FlowNodeDataDto> result = new ArrayList<FlowNodeDataDto>();
        for (FlowNode node : model.getModelElementsByType(FlowNode.class)) {
            FlowNodeDataDto flowNode = new FlowNodeDataDto(node.getId(), node.getName(), node.getElementType().getTypeName());
            result.add(flowNode);
        }
        return result;
    }

    public static Map<String, String> extractFlowNodeNames(List<FlowNodeDataDto> flowNodeData) {
        HashMap<String, String> flowNodeNames = new HashMap<String, String>();
        for (FlowNodeDataDto flowNode : flowNodeData) {
            flowNodeNames.put(flowNode.getId(), flowNode.getName());
        }
        return flowNodeNames;
    }

    public static Set<String> getCollapsedSubprocessElementIds(String xmlString) {
        BpmnModelInstance bpmnModelInstance = BpmnModelUtil.parseBpmnModel(xmlString);
        Map<String, Set> flowNodeIdsBySubprocessId = bpmnModelInstance.getModelElementsByType(SubProcess.class).stream().collect(Collectors.toMap(IdentifiableBpmnElement::getId, subProcess -> subProcess.getFlowElements().stream().map(IdentifiableBpmnElement::getId).collect(Collectors.toSet())));
        return bpmnModelInstance.getDefinitions().getBpmDiagrams().stream().flatMap(diagram -> diagram.getBpmnPlane().getDiagramElements().stream().filter(element -> flowNodeIdsBySubprocessId.containsKey(element.getAttributeValue(BPMN_ELEMENT_ATTRIBUTE)))).filter(subProcessElement -> !Boolean.parseBoolean(subProcessElement.getAttributeValue(IS_EXPANDED_ATTRIBUTE))).flatMap(collapsedSubProcess -> flowNodeIdsBySubprocessId.getOrDefault(collapsedSubProcess.getAttributeValue(BPMN_ELEMENT_ATTRIBUTE), Set.of()).stream()).collect(Collectors.toSet());
    }

    /*
     * Exception decompiling
     */
    public static String getResourceFileAsString(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

