/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.status;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.cluster.HealthRequest;
import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.status.StatusCheckingService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class StatusCheckingServiceES
extends StatusCheckingService {
    private final OptimizeElasticsearchClient esClient;

    public StatusCheckingServiceES(OptimizeElasticsearchClient esClient, OptimizeIndexNameService optimizeIndexNameService) {
        super(optimizeIndexNameService);
        this.esClient = esClient;
    }

    @Override
    public boolean isConnectedToDatabase() {
        try {
            HealthResponse healthResponse = this.esClient.getClusterHealth(HealthRequest.of(h -> h.index(this.optimizeIndexNameService.getIndexPrefix() + "*", new String[0])));
            return healthResponse.status() != HealthStatus.Red;
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

