/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.report;

import io.camunda.optimize.dto.optimize.query.report.AdditionalProcessReportEvaluationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.AuthorizedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.service.db.report.AuthorizationCheckReportEvaluationHandler;
import io.camunda.optimize.service.db.report.ReportEvaluationInfo;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportEvaluationService {
    private static final Logger LOG = LoggerFactory.getLogger(ReportEvaluationService.class);
    private final AuthorizationCheckReportEvaluationHandler reportEvaluator;

    public ReportEvaluationService(AuthorizationCheckReportEvaluationHandler reportEvaluator) {
        this.reportEvaluator = reportEvaluator;
    }

    public AuthorizedReportEvaluationResult evaluateSavedReportWithAdditionalFilters(String userId, ZoneId timezone, String reportId, AdditionalProcessReportEvaluationFilterDto filterDto, PaginationDto paginationDto) {
        ReportEvaluationInfo evaluationInfo = ReportEvaluationInfo.builder(reportId).userId(userId).timezone(timezone).pagination(paginationDto).additionalFilters(filterDto).build();
        return this.reportEvaluator.evaluateReport(evaluationInfo);
    }

    public AuthorizedReportEvaluationResult evaluateUnsavedReport(String userId, ZoneId timezone, ReportDefinitionDto reportDefinition, PaginationDto paginationDto) {
        reportDefinition.setOwner(null);
        reportDefinition.setLastModifier(null);
        ReportEvaluationInfo evaluationInfo = ReportEvaluationInfo.builder(reportDefinition).userId(userId).timezone(timezone).pagination(paginationDto).build();
        return this.reportEvaluator.evaluateReport(evaluationInfo);
    }
}

