/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.mediator.factory;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.datasource.ZeebeDataSourceDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.writer.ProcessInstanceWriter;
import io.camunda.optimize.service.importing.ImportIndexHandlerRegistry;
import io.camunda.optimize.service.importing.ImportMediator;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeIncidentImportService;
import io.camunda.optimize.service.importing.zeebe.db.ZeebeIncidentFetcher;
import io.camunda.optimize.service.importing.zeebe.mediator.ZeebeIncidentImportMediator;
import io.camunda.optimize.service.importing.zeebe.mediator.factory.AbstractZeebeImportMediatorFactory;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.stereotype.Component;

@Component
public class ZeebeIncidentImportMediatorFactory
extends AbstractZeebeImportMediatorFactory {
    private final ProcessInstanceWriter zeebeProcessInstanceWriter;
    private final ProcessDefinitionReader processDefinitionReader;

    public ZeebeIncidentImportMediatorFactory(BeanFactory beanFactory, ImportIndexHandlerRegistry importIndexHandlerRegistry, ConfigurationService configurationService, ProcessInstanceWriter zeebeProcessInstanceWriter, ProcessDefinitionReader processDefinitionReader, ObjectMapper objectMapper, DatabaseClient databaseClient) {
        super(beanFactory, importIndexHandlerRegistry, configurationService, objectMapper, databaseClient);
        this.zeebeProcessInstanceWriter = zeebeProcessInstanceWriter;
        this.processDefinitionReader = processDefinitionReader;
    }

    @Override
    public List<ImportMediator> createMediators(ZeebeDataSourceDto zeebeDataSourceDto) {
        return Collections.singletonList(new ZeebeIncidentImportMediator(this.importIndexHandlerRegistry.getZeebeIncidentImportIndexHandler(zeebeDataSourceDto.getPartitionId()), (ZeebeIncidentFetcher)this.beanFactory.getBean(ZeebeIncidentFetcher.class, new Object[]{zeebeDataSourceDto.getPartitionId(), this.databaseClient, this.objectMapper, this.configurationService}), new ZeebeIncidentImportService(this.configurationService, this.zeebeProcessInstanceWriter, zeebeDataSourceDto.getPartitionId(), this.processDefinitionReader, this.databaseClient), this.configurationService, new BackoffCalculator(this.configurationService)));
    }
}

