/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.ingested.service;

import io.camunda.optimize.dto.optimize.query.variable.ExternalProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableUpdateDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.writer.variable.ProcessVariableWriter;
import io.camunda.optimize.service.importing.DatabaseImportJob;
import io.camunda.optimize.service.importing.DatabaseImportJobExecutor;
import io.camunda.optimize.service.importing.engine.service.ImportService;
import io.camunda.optimize.service.importing.engine.service.ObjectVariableService;
import io.camunda.optimize.service.importing.job.ExternalVariableUpdateDatabaseImportJob;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalVariableUpdateImportService
implements ImportService<ExternalProcessVariableDto> {
    public static final long DEFAULT_VERSION = 1000L;
    private static final Logger LOG = LoggerFactory.getLogger(ExternalVariableUpdateImportService.class);
    private final DatabaseImportJobExecutor databaseImportJobExecutor;
    private final ProcessVariableWriter variableWriter;
    private final ConfigurationService configurationService;
    private final ObjectVariableService objectVariableService;
    private final DatabaseClient databaseClient;

    public ExternalVariableUpdateImportService(ConfigurationService configurationService, ProcessVariableWriter variableWriter, ObjectVariableService objectVariableService, DatabaseClient databaseClient) {
        this.databaseImportJobExecutor = new DatabaseImportJobExecutor(this.getClass().getSimpleName(), configurationService);
        this.variableWriter = variableWriter;
        this.configurationService = configurationService;
        this.objectVariableService = objectVariableService;
        this.databaseClient = databaseClient;
    }

    @Override
    public void executeImport(List<ExternalProcessVariableDto> pageOfExternalEntities, Runnable importCompleteCallback) {
        boolean newDataIsAvailable;
        LOG.trace("Importing external variable entities...");
        boolean bl = newDataIsAvailable = !pageOfExternalEntities.isEmpty();
        if (newDataIsAvailable) {
            List<ProcessVariableDto> newOptimizeEntities = this.mapExternalEntitiesToOptimizeEntities(pageOfExternalEntities);
            DatabaseImportJob<ProcessVariableDto> databaseImportJob = this.createDatabaseImportJob(newOptimizeEntities, importCompleteCallback);
            this.addDatabaseImportJobToQueue(databaseImportJob);
        }
    }

    @Override
    public DatabaseImportJobExecutor getDatabaseImportJobExecutor() {
        return this.databaseImportJobExecutor;
    }

    private void addDatabaseImportJobToQueue(DatabaseImportJob<?> databaseImportJob) {
        this.databaseImportJobExecutor.executeImportJob(databaseImportJob);
    }

    private List<ProcessVariableDto> mapExternalEntitiesToOptimizeEntities(List<ExternalProcessVariableDto> externalEntities) {
        List<ExternalProcessVariableDto> deduplicatedVariables = this.resolveDuplicateVariableUpdatesPerProcessInstance(externalEntities);
        List<ProcessVariableUpdateDto> processVariables = deduplicatedVariables.stream().map(this::convertExternalToProcessVariableDto).toList();
        return this.objectVariableService.convertToProcessVariableDtos(processVariables);
    }

    private List<ExternalProcessVariableDto> resolveDuplicateVariableUpdatesPerProcessInstance(List<ExternalProcessVariableDto> externalEntities) {
        ArrayList<ExternalProcessVariableDto> deduplicatedVariables = new ArrayList<ExternalProcessVariableDto>();
        HashMap<String, List> variablesByProcessInstanceId = new HashMap<String, List>();
        for (ExternalProcessVariableDto variable : externalEntities) {
            variablesByProcessInstanceId.putIfAbsent(variable.getProcessInstanceId(), new ArrayList());
            ((List)variablesByProcessInstanceId.get(variable.getProcessInstanceId())).add(variable);
        }
        variablesByProcessInstanceId.forEach((id, vars) -> deduplicatedVariables.addAll(this.resolveDuplicateVariableUpdates((List<ExternalProcessVariableDto>)vars)));
        return deduplicatedVariables;
    }

    private Set<ExternalProcessVariableDto> resolveDuplicateVariableUpdates(List<ExternalProcessVariableDto> externalEntities) {
        return new HashSet<ExternalProcessVariableDto>(externalEntities.stream().collect(Collectors.toMap(ExternalProcessVariableDto::getVariableId, Function.identity(), (var1, var2) -> var1.getIngestionTimestamp().compareTo(var2.getIngestionTimestamp()) > 0 ? var1 : var2)).values());
    }

    private ProcessVariableUpdateDto convertExternalToProcessVariableDto(ExternalProcessVariableDto externalVariable) {
        HashMap<String, String> valueInfo = new HashMap<String, String>();
        valueInfo.put("serializationDataFormat", externalVariable.getSerializationDataFormat());
        ProcessVariableUpdateDto processVariableUpdateDto = new ProcessVariableUpdateDto();
        processVariableUpdateDto.setId(externalVariable.getVariableId());
        processVariableUpdateDto.setName(externalVariable.getVariableName());
        processVariableUpdateDto.setType(externalVariable.getVariableType().getId());
        processVariableUpdateDto.setValue(externalVariable.getVariableValue());
        processVariableUpdateDto.setTimestamp(OffsetDateTime.ofInstant(Instant.ofEpochMilli(externalVariable.getIngestionTimestamp()), ZoneId.systemDefault()));
        processVariableUpdateDto.setValueInfo(valueInfo);
        processVariableUpdateDto.setProcessDefinitionKey(externalVariable.getProcessDefinitionKey());
        processVariableUpdateDto.setProcessInstanceId(externalVariable.getProcessInstanceId());
        processVariableUpdateDto.setVersion(Long.valueOf(1000L));
        return processVariableUpdateDto;
    }

    private DatabaseImportJob<ProcessVariableDto> createDatabaseImportJob(List<ProcessVariableDto> processVariables, Runnable callback) {
        ExternalVariableUpdateDatabaseImportJob importJob = new ExternalVariableUpdateDatabaseImportJob(this.variableWriter, this.configurationService, callback, this.databaseClient);
        importJob.setEntitiesToImport(processVariables);
        return importJob;
    }
}

