/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.engine.service;

import io.camunda.optimize.dto.optimize.index.PositionBasedImportIndexDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.writer.PositionBasedImportIndexWriter;
import io.camunda.optimize.service.importing.DatabaseImportJobExecutor;
import io.camunda.optimize.service.importing.engine.service.ImportService;
import io.camunda.optimize.service.importing.job.StorePositionBasedIndexDatabaseImportJob;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorePositionBasedIndexImportService
implements ImportService<PositionBasedImportIndexDto> {
    private static final Logger LOG = LoggerFactory.getLogger(StorePositionBasedIndexImportService.class);
    private final PositionBasedImportIndexWriter importIndexWriter;
    private final DatabaseImportJobExecutor databaseImportJobExecutor;
    private final DatabaseClient databaseClient;

    public StorePositionBasedIndexImportService(ConfigurationService configurationService, PositionBasedImportIndexWriter importIndexWriter, DatabaseClient databaseClient) {
        this.databaseImportJobExecutor = new DatabaseImportJobExecutor(this.getClass().getSimpleName(), configurationService);
        this.importIndexWriter = importIndexWriter;
        this.databaseClient = databaseClient;
    }

    public StorePositionBasedIndexImportService(PositionBasedImportIndexWriter importIndexWriter, DatabaseImportJobExecutor databaseImportJobExecutor, DatabaseClient databaseClient) {
        this.importIndexWriter = importIndexWriter;
        this.databaseImportJobExecutor = databaseImportJobExecutor;
        this.databaseClient = databaseClient;
    }

    @Override
    public void executeImport(List<PositionBasedImportIndexDto> importIndexesToStore, Runnable importCompleteCallback) {
        StorePositionBasedIndexDatabaseImportJob storeIndexesImportJob = new StorePositionBasedIndexDatabaseImportJob(this.importIndexWriter, importCompleteCallback, this.databaseClient);
        storeIndexesImportJob.setEntitiesToImport(importIndexesToStore);
        this.databaseImportJobExecutor.executeImportJob(storeIndexesImportJob);
    }

    @Override
    public DatabaseImportJobExecutor getDatabaseImportJobExecutor() {
        return this.databaseImportJobExecutor;
    }
}

