/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.engine.mediator;

import io.camunda.optimize.service.importing.ImportMediator;
import io.camunda.optimize.service.importing.engine.mediator.MediatorRank;
import io.camunda.optimize.service.importing.engine.service.ImportService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractStoreIndexesImportMediator<T extends ImportService>
implements ImportMediator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStoreIndexesImportMediator.class);
    protected T importService;
    protected OffsetDateTime dateUntilJobCreationIsBlocked;
    private final ConfigurationService configurationService;

    protected AbstractStoreIndexesImportMediator(T importService, ConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.dateUntilJobCreationIsBlocked = this.calculateDateUntilJobCreationIsBlocked();
        this.importService = importService;
    }

    @Override
    public long getBackoffTimeInMs() {
        long backoffTime = OffsetDateTime.now().until(this.dateUntilJobCreationIsBlocked, ChronoUnit.MILLIS);
        backoffTime = Math.max(0L, backoffTime);
        return backoffTime;
    }

    @Override
    public void resetBackoff() {
        this.dateUntilJobCreationIsBlocked = OffsetDateTime.MIN;
    }

    @Override
    public boolean canImport() {
        return OffsetDateTime.now().isAfter(this.dateUntilJobCreationIsBlocked);
    }

    @Override
    public boolean hasPendingImportJobs() {
        return this.importService.hasPendingImportJobs();
    }

    @Override
    public void shutdown() {
        this.importService.shutdown();
    }

    @Override
    public MediatorRank getRank() {
        return MediatorRank.IMPORT_META_DATA;
    }

    protected OffsetDateTime calculateDateUntilJobCreationIsBlocked() {
        return OffsetDateTime.now().plusSeconds(this.configurationService.getImportIndexAutoStorageIntervalInSec());
    }
}

