/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.optimize.dto.optimize.SchedulerConfig;
import io.camunda.optimize.dto.optimize.ZeebeConfigDto;
import io.camunda.optimize.dto.optimize.datasource.ZeebeDataSourceDto;
import io.camunda.optimize.service.importing.AbstractImportScheduler;
import io.camunda.optimize.service.importing.ImportIndexHandlerRegistry;
import io.camunda.optimize.service.importing.ImportMediator;
import io.camunda.optimize.service.importing.ingested.IngestedDataImportScheduler;
import io.camunda.optimize.service.importing.ingested.handler.IngestedImportIndexHandlerProvider;
import io.camunda.optimize.service.importing.ingested.mediator.factory.AbstractIngestedImportMediatorFactory;
import io.camunda.optimize.service.importing.zeebe.ZeebeImportScheduler;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeImportIndexHandlerProvider;
import io.camunda.optimize.service.importing.zeebe.mediator.factory.AbstractZeebeImportMediatorFactory;
import io.camunda.optimize.service.importing.zeebe.mediator.factory.ZeebeVariableImportMediatorFactory;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ZeebeConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ImportSchedulerManagerService
implements ConfigurationReloadable {
    private static final Logger LOG = LoggerFactory.getLogger(ImportSchedulerManagerService.class);
    private final ImportIndexHandlerRegistry importIndexHandlerRegistry;
    private final BeanFactory beanFactory;
    private final ConfigurationService configurationService;
    private final List<AbstractIngestedImportMediatorFactory> ingestedMediatorFactories;
    private final List<AbstractZeebeImportMediatorFactory> zeebeMediatorFactories;
    @Autowired
    private Environment environment;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="False positives")
    private List<AbstractImportScheduler<? extends SchedulerConfig>> importSchedulers = new ArrayList<AbstractImportScheduler<? extends SchedulerConfig>>();

    public ImportSchedulerManagerService(ImportIndexHandlerRegistry importIndexHandlerRegistry, BeanFactory beanFactory, ConfigurationService configurationService, List<AbstractIngestedImportMediatorFactory> ingestedMediatorFactories, List<AbstractZeebeImportMediatorFactory> zeebeMediatorFactories) {
        this.importIndexHandlerRegistry = importIndexHandlerRegistry;
        this.beanFactory = beanFactory;
        this.configurationService = configurationService;
        this.ingestedMediatorFactories = ingestedMediatorFactories;
        this.zeebeMediatorFactories = zeebeMediatorFactories.stream().filter(factory -> !(factory instanceof ZeebeVariableImportMediatorFactory) || configurationService.getConfiguredZeebe().isVariableImportEnabled()).collect(Collectors.toList());
        this.initSchedulers();
    }

    @PreDestroy
    public synchronized void shutdown() {
        for (AbstractImportScheduler<? extends SchedulerConfig> oldScheduler : this.importSchedulers) {
            oldScheduler.stopImportScheduling();
            oldScheduler.shutdown();
        }
    }

    @PostConstruct
    public void init() {
        if (!Boolean.parseBoolean(this.environment.getProperty("integrationTests"))) {
            this.startSchedulers();
        }
    }

    public synchronized void startSchedulers() {
        for (AbstractImportScheduler<? extends SchedulerConfig> scheduler : this.importSchedulers) {
            if (this.configurationService.isImportEnabled(scheduler.getDataImportSourceDto())) {
                scheduler.startImportScheduling();
                continue;
            }
            LOG.info("Import was disabled by config for import source {}.", (Object)scheduler.getDataImportSourceDto());
        }
    }

    public synchronized void stopSchedulers() {
        for (AbstractImportScheduler<? extends SchedulerConfig> scheduler : this.importSchedulers) {
            scheduler.stopImportScheduling();
        }
    }

    public synchronized void reloadConfiguration(ApplicationContext context) {
        this.shutdown();
        this.importIndexHandlerRegistry.reloadConfiguration();
        this.initSchedulers();
    }

    public Optional<IngestedDataImportScheduler> getIngestedDataImportScheduler() {
        List ingestedDataImportSchedulers = this.importSchedulers.stream().filter(IngestedDataImportScheduler.class::isInstance).map(IngestedDataImportScheduler.class::cast).collect(Collectors.toList());
        if (ingestedDataImportSchedulers.size() > 1) {
            throw new IllegalStateException("There should only be a single Ingested Data Import Scheduler");
        }
        return ingestedDataImportSchedulers.stream().findFirst();
    }

    public Optional<ZeebeImportScheduler> getZeebeImportScheduler() {
        List zeebeSchedulers = this.importSchedulers.stream().filter(ZeebeImportScheduler.class::isInstance).map(ZeebeImportScheduler.class::cast).collect(Collectors.toList());
        if (zeebeSchedulers.size() > 1) {
            throw new IllegalStateException("There should only be a single Zeebe Import Scheduler");
        }
        return zeebeSchedulers.stream().findFirst();
    }

    private synchronized void initSchedulers() {
        ArrayList<AbstractImportScheduler<? extends SchedulerConfig>> schedulers = new ArrayList<AbstractImportScheduler<? extends SchedulerConfig>>();
        schedulers.add(new IngestedDataImportScheduler(this.createIngestedDataMediatorList()));
        ZeebeConfiguration zeebeConfig = this.configurationService.getConfiguredZeebe();
        if (zeebeConfig.isEnabled()) {
            ArrayList<ImportMediator> zeebeMediatorList = new ArrayList<ImportMediator>();
            for (int partitionId = 1; partitionId <= zeebeConfig.getPartitionCount(); ++partitionId) {
                zeebeMediatorList.addAll(this.createZeebeMediatorList(new ZeebeDataSourceDto(zeebeConfig.getName(), partitionId)));
            }
            ZeebeImportScheduler zeebeImportScheduler = new ZeebeImportScheduler((List<ImportMediator>)zeebeMediatorList, new ZeebeConfigDto(zeebeConfig.getName(), zeebeConfig.getPartitionCount()));
            schedulers.add(zeebeImportScheduler);
        }
        this.importSchedulers = schedulers;
    }

    private List<ImportMediator> createIngestedDataMediatorList() {
        this.importIndexHandlerRegistry.register((IngestedImportIndexHandlerProvider)this.beanFactory.getBean(IngestedImportIndexHandlerProvider.class));
        return this.ingestedMediatorFactories.stream().map(AbstractIngestedImportMediatorFactory::createMediators).flatMap(Collection::stream).sorted(Comparator.comparing(ImportMediator::getRank)).collect(Collectors.toList());
    }

    private List<ImportMediator> createZeebeMediatorList(ZeebeDataSourceDto zeebeDataSourceDto) {
        this.importIndexHandlerRegistry.register(zeebeDataSourceDto.getPartitionId(), (ZeebeImportIndexHandlerProvider)this.beanFactory.getBean(ZeebeImportIndexHandlerProvider.class, new Object[]{zeebeDataSourceDto}));
        return this.zeebeMediatorFactories.stream().map(factory -> factory.createMediators(zeebeDataSourceDto)).flatMap(Collection::stream).sorted(Comparator.comparing(ImportMediator::getRank)).collect(Collectors.toList());
    }

    public List<AbstractImportScheduler<? extends SchedulerConfig>> getImportSchedulers() {
        return this.importSchedulers;
    }
}

