/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.optimize.dto.optimize.SchedulerConfig;
import io.camunda.optimize.service.AbstractScheduledService;
import io.camunda.optimize.service.importing.ImportMediator;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public abstract class AbstractImportScheduler<T extends SchedulerConfig>
extends AbstractScheduledService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractImportScheduler.class);
    protected final List<ImportMediator> importMediators;
    protected final T dataImportSourceDto;
    protected volatile boolean isImporting = false;

    public AbstractImportScheduler(List<ImportMediator> importMediators, T dataImportSourceDto) {
        this.importMediators = importMediators;
        this.dataImportSourceDto = dataImportSourceDto;
    }

    @Override
    public void run() {
        if (this.isScheduledToRun()) {
            LOG.debug("Next round!");
            try {
                this.runImportRound();
            }
            catch (Exception e) {
                LOG.error("Could not schedule next import round!", (Throwable)e);
            }
        }
    }

    @Override
    protected Trigger createScheduleTrigger() {
        return new PeriodicTrigger(Duration.ZERO);
    }

    public synchronized void startImportScheduling() {
        LOG.info("Start scheduling import from {}.", this.dataImportSourceDto);
        this.isImporting = true;
        this.startScheduling();
    }

    public synchronized void stopImportScheduling() {
        LOG.info("Stop scheduling import from {}.", this.dataImportSourceDto);
        this.isImporting = false;
        this.stopScheduling();
    }

    public void shutdown() {
        LOG.debug("Scheduler for {} will shutdown.", this.dataImportSourceDto);
        this.getImportMediators().forEach(ImportMediator::shutdown);
    }

    public Future<Void> runImportRound() {
        return this.runImportRound(false);
    }

    public Future<Void> runImportRound(boolean forceImport) {
        List<ImportMediator> currentImportRound = this.importMediators.stream().filter(mediator -> forceImport || mediator.canImport()).collect(Collectors.toList());
        if (this.nothingToBeImported(currentImportRound)) {
            this.isImporting = false;
            if (!forceImport) {
                this.doBackoff();
            }
            return CompletableFuture.completedFuture(null);
        }
        this.isImporting = true;
        return this.executeImportRound(currentImportRound);
    }

    public Future<Void> executeImportRound(List<ImportMediator> currentImportRound) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling import round for {}", (Object)currentImportRound.stream().map(mediator1 -> mediator1.getClass().getSimpleName()).collect(Collectors.joining(",")));
        }
        CompletableFuture[] importTaskFutures = (CompletableFuture[])currentImportRound.stream().map(mediator -> {
            try {
                return mediator.runImport();
            }
            catch (IllegalStateException e) {
                LOG.warn("Got into illegal state, will abort import round.", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.error("Was not able to execute import of [{}]", (Object)mediator.getClass().getSimpleName(), (Object)e);
                return CompletableFuture.completedFuture(null);
            }
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(importTaskFutures);
    }

    public boolean isImporting() {
        return this.isImporting || this.hasActiveImportJobs();
    }

    public List<ImportMediator> getImportMediators() {
        return this.importMediators;
    }

    protected boolean hasActiveImportJobs() {
        return this.importMediators.stream().anyMatch(ImportMediator::hasPendingImportJobs);
    }

    protected boolean nothingToBeImported(List<?> currentImportRound) {
        return currentImportRound.isEmpty();
    }

    protected void doBackoff() {
        long timeToSleep = this.importMediators.stream().map(ImportMediator::getBackoffTimeInMs).min(Long::compare).orElse(5000L);
        try {
            LOG.debug("No imports to schedule. Scheduler is sleeping for [{}] ms.", (Object)timeToSleep);
            Thread.sleep(timeToSleep);
        }
        catch (InterruptedException e) {
            LOG.error("Scheduler was interrupted while sleeping.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public T getDataImportSourceDto() {
        return this.dataImportSourceDto;
    }
}

