/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.identity;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.users.dto.User;
import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.service.security.CCSMTokenService;
import io.camunda.optimize.service.util.configuration.CacheConfiguration;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSMCondition;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSMCondition.class})
public class CCSMUserCache {
    private static final Logger LOG = LoggerFactory.getLogger(CCSMUserCache.class);
    private final Cache<String, UserDto> ccsmUsersCache;
    private final CCSMTokenService ccsmTokenService;
    private final Identity identity;

    public CCSMUserCache(ConfigurationService configurationService, CCSMTokenService ccsmTokenService, Identity identity) {
        this.ccsmTokenService = ccsmTokenService;
        this.identity = identity;
        CacheConfiguration userCacheConfig = configurationService.getCaches().getUsers();
        this.ccsmUsersCache = Caffeine.newBuilder().maximumSize((long)userCacheConfig.getMaxSize()).expireAfterWrite(Duration.ofMillis(userCacheConfig.getDefaultTtlMillis())).build();
    }

    public Optional<UserDto> getUserById(String userId) {
        return Optional.ofNullable((UserDto)this.ccsmUsersCache.get((Object)userId, id -> this.fetchUserFromIdentity((String)id).orElse(null)));
    }

    public List<UserDto> getUsersById(Set<String> userIds) {
        return this.getUsersById(userIds, userIds.size());
    }

    public List<UserDto> getUsersById(Set<String> userIds, int resultLimit) {
        Map cachedUsers = this.ccsmUsersCache.getAllPresent(userIds);
        List result = cachedUsers.values().stream().limit(resultLimit).collect(Collectors.toList());
        userIds.removeAll(cachedUsers.keySet());
        if (!userIds.isEmpty() && result.size() < resultLimit) {
            Map<String, UserDto> usersInIdentity = this.fetchUsersByIdFromIdentityIfExists(userIds);
            result.addAll(usersInIdentity.values());
            this.ccsmUsersCache.putAll(usersInIdentity);
        }
        return result.stream().limit(resultLimit).toList();
    }

    public List<UserDto> searchForIdentityUsingSearchTerm(String searchString, int maxResults) {
        List<UserDto> result;
        List<UserDto> list = result = StringUtils.isBlank((CharSequence)searchString) ? this.ccsmUsersCache.asMap().values().stream().limit(maxResults).toList() : this.ccsmUsersCache.asMap().values().stream().filter(user -> user.isIdentityContainsSearchTerm(searchString)).limit(maxResults).toList();
        if (result.isEmpty()) {
            result = this.searchUsersInIdentity(searchString, maxResults);
        }
        return result;
    }

    public List<UserDto> searchForUsersUsingEmails(Set<String> emails) {
        List<UserDto> result = this.ccsmUsersCache.asMap().values().stream().filter(user -> StringUtils.equalsAny((CharSequence)user.getEmail(), (CharSequence[])emails.toArray(new String[0]))).collect(Collectors.toList());
        if (result.size() < emails.size()) {
            emails.removeAll(result.stream().map(UserDto::getEmail).collect(Collectors.toSet()));
            result.addAll(emails.stream().flatMap(email -> this.searchUsersInIdentity((String)email, 1).stream()).filter(user -> StringUtils.equalsAny((CharSequence)user.getEmail(), (CharSequence[])emails.toArray(new String[0]))).toList());
        }
        return result;
    }

    private Optional<UserDto> getUserFromIdentity(String token, String userId) {
        try {
            return this.identity.users().withAccessToken(token).get(Collections.singletonList(userId)).stream().findFirst().map(this::mapToUserDto);
        }
        catch (Exception e) {
            LOG.warn("Failed retrieving user by ID from Camunda Identity.", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<UserDto> fetchUserFromIdentity(String userId) {
        if (this.identity.users().isAvailable()) {
            Optional<String> token = this.ccsmTokenService.getCurrentUserAuthToken();
            if (token.isPresent()) {
                return this.getUserFromIdentity(token.get(), userId);
            }
            LOG.warn("Could not retrieve user because no user token present.");
            return Optional.empty();
        }
        LOG.info("Cannot search for user by ID because user search not available in Camunda identity.");
        return Optional.empty();
    }

    private Map<String, UserDto> fetchUsersByIdFromIdentityIfExists(Set<String> userIds) {
        if (this.identity.users().isAvailable()) {
            Optional<String> token = this.ccsmTokenService.getCurrentUserAuthToken();
            if (token.isPresent()) {
                return userIds.stream().map(id -> this.getUserFromIdentity((String)token.get(), (String)id)).flatMap(Optional::stream).collect(Collectors.toMap(IdentityDto::getId, Function.identity()));
            }
            LOG.warn("Could not retrieve user because no user token present.");
            return Collections.emptyMap();
        }
        LOG.info("Cannot search for user by ID because user search not available in Camunda identity.");
        return Collections.emptyMap();
    }

    private List<UserDto> searchUsersInIdentity(String searchString, int maxResults) {
        if (this.identity.users().isAvailable()) {
            Optional<String> token = this.ccsmTokenService.getCurrentUserAuthToken();
            searchString = searchString.toLowerCase(Locale.ENGLISH);
            if (token.isPresent()) {
                try {
                    return this.identity.users().withAccessToken(token.get()).search(searchString).stream().limit(maxResults).map(this::mapToUserDto).toList();
                }
                catch (Exception e) {
                    LOG.warn("Failed searching for users with searchString [{}] in Camunda Identity.", (Object)searchString, (Object)e);
                    return Collections.emptyList();
                }
            }
            LOG.warn("Could not search for users because no user token present.");
            return Collections.emptyList();
        }
        LOG.info("Cannot search for users because no user search available in Camunda Identity.");
        return Collections.emptyList();
    }

    @NotNull
    private UserDto mapToUserDto(User user) {
        return new UserDto(user.getId(), user.getName(), user.getEmail(), Collections.emptyList());
    }
}

