/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.export;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import io.camunda.optimize.dto.optimize.query.report.AuthorizedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginatedDataExportDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.service.db.report.PlainReportEvaluationHandler;
import io.camunda.optimize.service.db.report.ReportEvaluationInfo;
import io.camunda.optimize.service.report.ReportService;
import java.time.ZoneId;
import java.util.Optional;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonReportResultExportService {
    private static final Logger LOG = LoggerFactory.getLogger(JsonReportResultExportService.class);
    private final PlainReportEvaluationHandler reportEvaluationHandler;
    private final ReportService reportService;

    public JsonReportResultExportService(PlainReportEvaluationHandler reportEvaluationHandler, ReportService reportService) {
        this.reportEvaluationHandler = reportEvaluationHandler;
        this.reportService = reportService;
    }

    public PaginatedDataExportDto getJsonForEvaluatedReportResult(String reportId, ZoneId timezone, PaginationDto paginationInfo) throws Exception {
        LOG.info("Exporting provided report " + reportId + " as JSON.");
        ReportDefinitionDto<ReportDataDto> reportData = this.reportService.getReportDefinition(reportId);
        ReportDataDto unevaluatedReportData = reportData.getData();
        if (unevaluatedReportData instanceof SingleReportDataDto) {
            boolean isRawDataReport = ((SingleReportDataDto)unevaluatedReportData).getViewProperties().contains(ViewProperty.RAW_DATA);
            ReportEvaluationInfo.ReportEvaluationInfoBuilder evaluationInfoBuilder = ReportEvaluationInfo.builder(reportId).timezone(timezone).isCsvExport(false).isJsonExport(true);
            if (isRawDataReport) {
                evaluationInfoBuilder.pagination(paginationInfo);
            }
            try {
                AuthorizedReportEvaluationResult reportResult = this.reportEvaluationHandler.evaluateReport(evaluationInfoBuilder.build());
                PaginatedDataExportDto resultAsJson = reportResult.getEvaluationResult().getResult();
                resultAsJson.setReportId(reportId);
                if (!isRawDataReport && paginationInfo.getLimit() < resultAsJson.getNumberOfRecordsInResponse()) {
                    resultAsJson.setMessage("All records are delivered in this response regardless of the set limit, since result pagination is only supported for raw data reports.");
                }
                LOG.info("Report " + reportId + " exported successfully as JSON.");
                return resultAsJson;
            }
            catch (RuntimeException e) {
                throw this.processAndEnrichExceptionWithMessage(e);
            }
        }
        throw new BadRequestException("Combined reports cannot be exported as Json");
    }

    private Exception processAndEnrichExceptionWithMessage(RuntimeException e) {
        if (e instanceof ElasticsearchException) {
            ElasticsearchException elasticExc = (ElasticsearchException)e;
            return Optional.ofNullable(elasticExc.response().error().causedBy()).filter(pag -> {
                assert (pag.type() != null);
                return pag.type().contains("search_context_missing_exception");
            }).map(pag -> new BadRequestException(pag.reason())).orElse(e);
        }
        if (e instanceof OpenSearchException) {
            OpenSearchException openSearchExc = (OpenSearchException)e;
            return Optional.ofNullable(openSearchExc.response().error().causedBy()).filter(pag -> {
                assert (pag.type() != null);
                return pag.type().contains("search_context_missing_exception");
            }).map(pag -> new BadRequestException(pag.reason())).orElse(e);
        }
        return e;
    }
}

