/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.writer.variable;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.ImportRequestDto;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.RequestType;
import io.camunda.optimize.dto.optimize.datasource.DataSourceDto;
import io.camunda.optimize.dto.optimize.datasource.EngineDataSourceDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.SimpleProcessVariableDto;
import io.camunda.optimize.service.db.repository.IndexRepository;
import io.camunda.optimize.service.db.repository.VariableRepository;
import io.camunda.optimize.service.db.repository.script.ProcessVariableScriptFactory;
import io.camunda.optimize.service.db.schema.ScriptData;
import io.camunda.optimize.service.db.schema.index.IndexMappingCreatorBuilder;
import io.camunda.optimize.service.db.writer.DatabaseWriterUtil;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.VariableHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessVariableWriter {
    private static final String VARIABLE_UPDATES_FROM_ENGINE = "variableUpdatesFromEngine";
    private static final Logger LOG = LoggerFactory.getLogger(ProcessVariableWriter.class);
    private final ObjectMapper objectMapper;
    private final IndexRepository indexRepository;
    private final VariableRepository variableRepository;

    public ProcessVariableWriter(ObjectMapper objectMapper, IndexRepository indexRepository, VariableRepository variableRepository) {
        this.objectMapper = objectMapper;
        this.indexRepository = indexRepository;
        this.variableRepository = variableRepository;
    }

    public List<ImportRequestDto> generateVariableUpdateImports(List<ProcessVariableDto> variables) {
        String importItemName = "variables";
        LOG.debug("Creating imports for {} [{}].", (Object)variables.size(), (Object)"variables");
        Set<String> keys = variables.stream().map(ProcessVariableDto::getProcessDefinitionKey).collect(Collectors.toSet());
        this.indexRepository.createMissingIndices(IndexMappingCreatorBuilder.PROCESS_INSTANCE_INDEX, Set.of("process-instance"), keys);
        Map<String, List<ProcessVariableDto>> processInstanceIdToVariables = this.groupVariablesByProcessInstanceIds(variables);
        return processInstanceIdToVariables.entrySet().stream().map(entry -> this.createUpdateRequestForProcessInstanceVariables((Map.Entry<String, List<ProcessVariableDto>>)entry, "variables")).collect(Collectors.toList());
    }

    public void deleteVariableDataByProcessInstanceIds(String processDefinitionKey, List<String> processInstanceIds) {
        LOG.debug("Deleting variable data on [{}] process instance documents with bulk request.", (Object)processInstanceIds.size());
        this.variableRepository.deleteVariableDataByProcessInstanceIds(processDefinitionKey, processInstanceIds);
    }

    private ImportRequestDto createUpdateRequestForProcessInstanceVariables(Map.Entry<String, List<ProcessVariableDto>> processInstanceIdToVariables, String importItemName) {
        List<ProcessVariableDto> variablesWithAllInformation = processInstanceIdToVariables.getValue();
        String processInstanceId = processInstanceIdToVariables.getKey();
        String processDefinitionKey = variablesWithAllInformation.get(0).getProcessDefinitionKey();
        List<SimpleProcessVariableDto> variables = this.mapToSimpleVariables(variablesWithAllInformation);
        Map<String, Object> params = this.buildParameters(variables);
        ScriptData updateScriptData = DatabaseWriterUtil.createScriptData(this.createInlineUpdateScript(), params, this.objectMapper);
        if (variablesWithAllInformation.isEmpty()) {
            return null;
        }
        ProcessVariableDto firstVariable = variablesWithAllInformation.get(0);
        ProcessInstanceDto processInstanceDto = this.getNewProcessInstanceRecord(processInstanceId, firstVariable.getEngineAlias(), firstVariable.getTenantId(), variables);
        return ImportRequestDto.builder().indexName(InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)).importName(importItemName).type(RequestType.UPDATE).id(processInstanceId).scriptData(updateScriptData).source((Object)processInstanceDto).retryNumberOnConflict(5).build();
    }

    private Map<String, List<ProcessVariableDto>> groupVariablesByProcessInstanceIds(List<ProcessVariableDto> variableUpdates) {
        HashMap<String, List<ProcessVariableDto>> processInstanceIdToVariables = new HashMap<String, List<ProcessVariableDto>>();
        for (ProcessVariableDto variable : variableUpdates) {
            if (this.isVariableFromCaseDefinition(variable) || !VariableHelper.isProcessVariableTypeSupported((String)variable.getType())) {
                LOG.warn("Variable [{}] is either a case definition variable or the type [{}] is not supported!", (Object)variable, (Object)variable.getType());
                continue;
            }
            processInstanceIdToVariables.putIfAbsent(variable.getProcessInstanceId(), new ArrayList());
            ((List)processInstanceIdToVariables.get(variable.getProcessInstanceId())).add(variable);
        }
        return processInstanceIdToVariables;
    }

    private List<SimpleProcessVariableDto> mapToSimpleVariables(List<ProcessVariableDto> variablesWithAllInformation) {
        return variablesWithAllInformation.stream().map(var -> new SimpleProcessVariableDto(var.getId(), var.getName(), var.getType(), var.getValue(), var.getVersion().longValue())).map(variable -> {
            if (variable.getValue().stream().allMatch(Objects::isNull)) {
                variable.setValue(Collections.emptyList());
            }
            return variable;
        }).collect(Collectors.toList());
    }

    private Map<String, Object> buildParameters(List<SimpleProcessVariableDto> variables) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(VARIABLE_UPDATES_FROM_ENGINE, variables);
        return params;
    }

    private String createInlineUpdateScript() {
        StringBuilder builder = new StringBuilder();
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put("variables", "variables");
        substitutions.put(VARIABLE_UPDATES_FROM_ENGINE, VARIABLE_UPDATES_FROM_ENGINE);
        StringSubstitutor sub = new StringSubstitutor(substitutions);
        String variableScript = ProcessVariableScriptFactory.createInlineUpdateScript();
        String resolvedVariableScript = sub.replace(variableScript);
        builder.append(resolvedVariableScript);
        return builder.toString();
    }

    private ProcessInstanceDto getNewProcessInstanceRecord(String processInstanceId, String engineAlias, String tenantId, List<SimpleProcessVariableDto> variables) {
        ProcessInstanceDto procInst = ProcessInstanceDto.builder().processInstanceId(processInstanceId).dataSource((DataSourceDto)new EngineDataSourceDto(engineAlias)).tenantId(tenantId).build();
        procInst.getVariables().addAll(variables);
        return procInst;
    }

    private boolean isVariableFromCaseDefinition(ProcessVariableDto variable) {
        return variable.getProcessInstanceId() == null;
    }
}

