/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.writer.variable;

import io.camunda.optimize.dto.optimize.query.variable.ExternalProcessVariableDto;
import io.camunda.optimize.service.db.repository.TaskRepository;
import io.camunda.optimize.service.db.repository.VariableRepository;
import java.time.OffsetDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExternalProcessVariableWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalProcessVariableWriter.class);
    private final VariableRepository variableRepository;
    private final TaskRepository taskRepository;

    public ExternalProcessVariableWriter(VariableRepository variableRepository, TaskRepository taskRepository) {
        this.variableRepository = variableRepository;
        this.taskRepository = taskRepository;
    }

    public void writeExternalProcessVariables(List<ExternalProcessVariableDto> variables) {
        String itemName = "external process variables";
        LOG.debug("Writing {} {} to Database.", (Object)variables.size(), (Object)"external process variables");
        this.variableRepository.writeExternalProcessVariables(variables, "external process variables");
    }

    public void deleteExternalVariablesIngestedBefore(OffsetDateTime timestamp) {
        String deletedItemIdentifier = String.format("external variables with timestamp older than %s", timestamp);
        LOG.info("Deleting {}", (Object)deletedItemIdentifier);
        this.taskRepository.executeWithTaskMonitoring("indices:data/write/delete/byquery", () -> this.variableRepository.deleteExternalVariablesIngestedBefore(timestamp, deletedItemIdentifier), LOG);
    }
}

