/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.script;

import java.text.MessageFormat;

public interface ProcessInstanceScriptFactory {
    public static String createDeleteEventsWithIdsInScript() {
        return MessageFormat.format("ctx._source.{0}.removeIf(event -> params.eventIdsToDelete.contains(event.{1}));\n", "flowNodeInstances", "flowNodeInstanceId");
    }

    public static String createVariableClearScript() {
        return MessageFormat.format("ctx._source.{0} = new ArrayList();\n", "variables");
    }

    public static String createInlineUpdateScript() {
        return "if ((ctx._source.state == params.activeState || ctx._source.state == params.suspendedState) && (params.newState.equals(params.activeState) || params.newState.equals(params.suspendedState))) {ctx._source.state = params.newState;}\n";
    }

    public static String createEventInlineUpdateScript() {
        return ProcessInstanceScriptFactory.createInstanceUpdateFunction() + ProcessInstanceScriptFactory.createRemoveExistingGatewaysFunction() + ProcessInstanceScriptFactory.createNewGatewayFunction() + ProcessInstanceScriptFactory.createAddGatewaysForProcessInstanceFunction() + ProcessInstanceScriptFactory.addOpeningGatewayInstancesFunction() + ProcessInstanceScriptFactory.addClosingGatewayInstancesFunction() + "void calculateAndAssignEventDuration(def event, def formatter) {\nif (event.startDate != null && event.endDate != null) {\n  event.totalDurationInMs = formatter.parse(event.endDate).getTime() - formatter.parse(event.startDate).getTime();\n}\n}\ndef dateFormatter = new SimpleDateFormat(params.dateFormatPattern);\ndef processInstance = ctx._source;\ndef processInstanceUpdate = params.processInstance;\ndef eventDateComparator = Comparator\n.comparing(event -> event.startDate, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(event -> event.endDate, Comparator.nullsFirst(Comparator.naturalOrder()));\nfor (def variableEntry : processInstanceUpdate.variables) {\nprocessInstance.variables.removeIf(item -> item.id.equals(variableEntry.id));\n}\nprocessInstance.variables.addAll(processInstanceUpdate.variables);\nremoveExistingGateways(processInstance, params.gatewayLookup);\nMap existingEventsByIdMap = processInstance.flowNodeInstances.stream()\n.collect(Collectors.toMap(event -> event.flowNodeInstanceId, Function.identity()));\ndef eventUpserts = processInstanceUpdate.flowNodeInstances;\nfor (def eventUpsert : eventUpserts) {\ndef event = existingEventsByIdMap.get(eventUpsert.flowNodeInstanceId);\nif (event == null) {\n  existingEventsByIdMap.put(eventUpsert.flowNodeInstanceId, eventUpsert);\n  event = eventUpsert;\n} else {\n  event.startDate = eventUpsert.startDate ?: event.startDate;\n  event.endDate = eventUpsert.endDate ?: event.endDate;\n  if (event.canceled == false && eventUpsert.canceled == true) { \n    event.canceled = eventUpsert.canceled;\n  }\n}\ncalculateAndAssignEventDuration(event, dateFormatter);\n}\nMap existingFlowNodeInstancesByFlowNodeId = existingEventsByIdMap.values().stream()\n.collect(Collectors.groupingBy(event -> event.flowNodeId));\nexistingFlowNodeInstancesByFlowNodeId\n.values()\n.forEach(byFlowNodeIdList -> byFlowNodeIdList.sort(eventDateComparator));\ndef correlatedEventsById = processInstance.correlatedEventsById;\nprocessInstanceUpdate.correlatedEventsById.forEach((eventId, correlationStateUpdate) -> {\ncorrelatedEventsById.putIfAbsent(eventId, correlationStateUpdate);\n});\nList pendingFlowNodeInstanceUpdates = new ArrayList(processInstance.pendingFlowNodeInstanceUpdates);\nfor (def newPendingUpdate : processInstanceUpdate.pendingFlowNodeInstanceUpdates) {\npendingFlowNodeInstanceUpdates.removeIf(existingUpdate -> existingUpdate.id.equals(newPendingUpdate.id));\npendingFlowNodeInstanceUpdates.add(newPendingUpdate);\n}\nCollections.sort(pendingFlowNodeInstanceUpdates, Comparator.comparing(flowNodeInstanceUpdate -> flowNodeInstanceUpdate.date, Comparator.naturalOrder()));\nSet appliedUpdates = new HashSet();\nfor (def flowNodeInstanceUpdate : pendingFlowNodeInstanceUpdates) {\ndef correlatedEventState = correlatedEventsById.get(flowNodeInstanceUpdate.sourceEventId);\ndef correlatedAsInstanceIds = correlatedEventState.correlatedAsToFlowNodeInstanceIds\n.computeIfAbsent(flowNodeInstanceUpdate.mappedAs, key -> new ArrayList());\ndef updateableFlowNodeInstance = Optional.ofNullable(existingFlowNodeInstancesByFlowNodeId.get(flowNodeInstanceUpdate.flowNodeId))\n.flatMap(flowNodeInstances -> flowNodeInstances.stream()\n.filter(flowNodeInstance -> {\n  return correlatedAsInstanceIds.contains(flowNodeInstance.flowNodeInstanceId) || flowNodeInstance.startDate == null || flowNodeInstance.endDate == null\n})\n.findFirst()\n);\nif(updateableFlowNodeInstance.isPresent()) {\n  def flowNodeInstanceToUpdate = updateableFlowNodeInstance.get();\n  def wasAlreadyCorrelated = correlatedAsInstanceIds.contains(flowNodeInstanceToUpdate.flowNodeInstanceId);\n  def eventDate = dateFormatter.parse(flowNodeInstanceUpdate.date);\n  if (flowNodeInstanceUpdate.mappedAs.equals(\"START\")\n    && (wasAlreadyCorrelated || eventDate.before(dateFormatter.parse(flowNodeInstanceToUpdate.endDate)))) {\n    flowNodeInstanceToUpdate.startDate = flowNodeInstanceUpdate.date;\n    appliedUpdates.add(flowNodeInstanceUpdate);\n  } else if (flowNodeInstanceUpdate.mappedAs.equals(\"END\")\n    && (wasAlreadyCorrelated ||  eventDate.after(dateFormatter.parse(flowNodeInstanceToUpdate.startDate)))) {\n    flowNodeInstanceToUpdate.endDate = flowNodeInstanceUpdate.date;\n    appliedUpdates.add(flowNodeInstanceUpdate);\n  }\n  if (appliedUpdates.contains(flowNodeInstanceUpdate)) {\n    if (!correlatedAsInstanceIds.contains(flowNodeInstanceToUpdate.flowNodeInstanceId)) {\n      correlatedAsInstanceIds.add(flowNodeInstanceToUpdate.flowNodeInstanceId);\n    }\n    calculateAndAssignEventDuration(flowNodeInstanceToUpdate, dateFormatter);\n  }\n}\n}\nprocessInstance.flowNodeInstances = new ArrayList(\nexistingFlowNodeInstancesByFlowNodeId.values().stream().flatMap(List::stream).collect(Collectors.toList())\n);\nprocessInstance.pendingFlowNodeInstanceUpdates = pendingFlowNodeInstanceUpdates.stream()\n.filter(flowNodeInstanceUpdate -> !appliedUpdates.contains(flowNodeInstanceUpdate))\n.collect(Collectors.toList());\naddGatewaysForProcessInstance(processInstance, params.gatewayLookup, eventDateComparator, processInstanceUpdate.processInstanceId, dateFormatter);\nupdateProcessInstance(processInstance, dateFormatter);\n";
    }

    private static String createInstanceUpdateFunction() {
        return "void updateProcessInstance(def instance, def formatter) {\ndef startDate = instance.flowNodeInstances.stream()\n  .filter(event -> event.flowNodeType.equals(\"startEvent\"))\n  .map(event -> event.startDate)\n  .filter(value -> value != null)\n  .sorted()\n  .findFirst()\n  .ifPresent(value -> instance.startDate = value);\ndef endDate = instance.flowNodeInstances.stream()\n  .filter(event -> event.flowNodeType.equals(\"endEvent\"))\n  .map(event -> event.endDate)\n  .filter(value -> value != null)\n  .sorted(Comparator.reverseOrder())\n  .findFirst()\n  .ifPresent(value -> instance.endDate = value);\nif(instance.endDate != null) {\n  instance.state = \"COMPLETED\";\n} else {  instance.state = \"ACTIVE\";\n}\nif (instance.startDate != null && instance.endDate != null) {\n  instance.duration = formatter.parse(instance.endDate).getTime() - formatter.parse(instance.startDate).getTime();\n}}\n";
    }

    private static String createRemoveExistingGatewaysFunction() {
        return "void removeExistingGateways(def instance, def gatewayLookup) {\ngatewayLookup.forEach(gatewayEvent -> \ninstance.flowNodeInstances.removeIf(event -> gatewayEvent.id.equals(event.flowNodeId))\n)}\n";
    }

    private static String createAddGatewaysForProcessInstanceFunction() {
        return "void addGatewaysForProcessInstance(def instance, def gatewayLookup, def startEndDateComparator, def processInstanceId, def dateFormatter) {\nList gatewayEventsToAdd = new ArrayList();\nList gatewayIdsInModel = gatewayLookup.stream().map(gateway -> gateway.id).collect(Collectors.toList());\nList existingEvents = new ArrayList(instance.flowNodeInstances);\nif (!existingEvents.isEmpty() && !gatewayLookup.isEmpty()) { \nCollections.sort(existingEvents, startEndDateComparator);\nfor (def possibleGateway : gatewayLookup) {\nint eventAddedCount = 0;\nif (possibleGateway.previousNodeIds.size() == 1) {\naddOpeningGatewayInstances(possibleGateway, gatewayIdsInModel, existingEvents, gatewayEventsToAdd,eventAddedCount, processInstanceId, instance.processDefinitionKey, dateFormatter);\n} else if (possibleGateway.nextNodeIds.size() == 1) {\naddClosingGatewayInstances(possibleGateway, gatewayIdsInModel, existingEvents, gatewayEventsToAdd,eventAddedCount, processInstanceId, instance.processDefinitionKey, dateFormatter);\n}\n}\nexistingEvents.addAll(gatewayEventsToAdd);\nCollections.sort(existingEvents, startEndDateComparator);\ninstance.flowNodeInstances = existingEvents;\n}\n}\n";
    }

    private static String addOpeningGatewayInstancesFunction() {
        return "void addOpeningGatewayInstances(def possibleGateway, def gatewayIdsInModel, def existingEvents, def gatewayEventsToAdd,def eventAddedCount, def processInstanceId, def definitionKey, def dateFormatter) {\nif (possibleGateway.type.equals(\"eventBasedGateway\")) {\ndef previousNodeId = possibleGateway.previousNodeIds.get(0);\nif (gatewayIdsInModel.contains(previousNodeId)) {\nfor (def event : existingEvents) {\nif (possibleGateway.nextNodeIds.contains(event.flowNodeId) && event.startDate != null) {\neventAddedCount ++;\ndef newGateway = createNewGateway(possibleGateway.id, possibleGateway.type, \nevent.startDate, event.startDate, processInstanceId, definitionKey, eventAddedCount);\ngatewayEventsToAdd.add(newGateway);\n}\n}\n} else {\nList targetEvents = existingEvents.stream().filter(event -> possibleGateway.nextNodeIds.contains(event.flowNodeId) && event.startDate != null)\n.collect(Collectors.toList());\nList sourceEvents = existingEvents.stream().filter(event -> possibleGateway.previousNodeIds.get(0).equals(event.flowNodeId) && event.endDate != null)\n.collect(Collectors.toList());\nboolean gatewayCanBeAdded = !sourceEvents.isEmpty() && !targetEvents.isEmpty();\nwhile (gatewayCanBeAdded) {\ndef sourceEvent = sourceEvents.remove(0);\ndef targetEvent = targetEvents.remove(0);\neventAddedCount ++;\ndef newGateway = createNewGateway(possibleGateway.id, possibleGateway.type, \nsourceEvent.endDate, targetEvent.startDate, processInstanceId, definitionKey, eventAddedCount);\ncalculateAndAssignEventDuration(newGateway, dateFormatter);\ngatewayEventsToAdd.add(newGateway);\ngatewayCanBeAdded = !sourceEvents.isEmpty() && !targetEvents.isEmpty();\n}\n}\n} else if (!gatewayIdsInModel.contains(possibleGateway.previousNodeIds.get(0))) {for (def event : existingEvents) {\nif (possibleGateway.previousNodeIds.contains(event.flowNodeId) && event.endDate != null) {\neventAddedCount ++;\ndef newGateway = createNewGateway(possibleGateway.id, possibleGateway.type, \nevent.endDate, event.endDate, processInstanceId, definitionKey, eventAddedCount);\ngatewayEventsToAdd.add(newGateway);\n}\n}\n} else {\nfor (def event : existingEvents) {\nif (possibleGateway.nextNodeIds.contains(event.flowNodeId)) {\neventAddedCount ++;\ndef newGateway = createNewGateway(possibleGateway.id, possibleGateway.type, \nevent.startDate, event.startDate, processInstanceId, definitionKey, eventAddedCount);\ngatewayEventsToAdd.add(newGateway);\n}\n}\n}\n}\n";
    }

    private static String addClosingGatewayInstancesFunction() {
        return "void addClosingGatewayInstances(def possibleGateway, def gatewayIdsInModel, def existingEvents, def gatewayEventsToAdd,def eventAddedCount, def processInstanceId, def definitionKey, def dateFormatter) {\nif (possibleGateway.type.equals(\"exclusiveGateway\")) {\nif (!gatewayIdsInModel.contains(possibleGateway.nextNodeIds.get(0))) {\nfor (def event : existingEvents) {\nif (possibleGateway.nextNodeIds.contains(event.flowNodeId)) {\neventAddedCount ++;\ndef newGateway = createNewGateway(possibleGateway.id, possibleGateway.type, \nevent.startDate, event.startDate, processInstanceId, definitionKey, eventAddedCount);\ngatewayEventsToAdd.add(newGateway);\n}\n}\n} else {for (def event : existingEvents) {\nif (possibleGateway.previousNodeIds.contains(event.flowNodeId) && event.endDate != null) {\neventAddedCount ++;\ndef newGateway = createNewGateway(possibleGateway.id, possibleGateway.type, \nevent.endDate, event.endDate, processInstanceId, definitionKey, eventAddedCount);\ngatewayEventsToAdd.add(newGateway);\n}\n}\n}\n} else if (possibleGateway.type.equals(\"parallelGateway\")) {\nMap relatedEventsByFlowNodeId = existingEvents.stream()\n.filter(event -> possibleGateway.previousNodeIds.contains(event.flowNodeId) && event.endDate != null)\n.collect(Collectors.groupingBy(event -> event.flowNodeId));\nList mappablePreviousNodeIds = possibleGateway.previousNodeIds.stream().filter(nodeId -> !gatewayIdsInModel.contains(nodeId))\n.collect(Collectors.toList());\nboolean gatewayCanBeAdded = relatedEventsByFlowNodeId.keySet().containsAll(mappablePreviousNodeIds);\nwhile (gatewayCanBeAdded) {\nList eventsForGateway = new ArrayList();\nfor (def previousNodeId : mappablePreviousNodeIds) {\neventsForGateway.add(relatedEventsByFlowNodeId.get(previousNodeId).remove(0));\n}\ndef endDateComparator = Comparator.comparing(event -> event.endDate, Comparator.nullsLast(Comparator.naturalOrder()));\nCollections.sort(eventsForGateway, endDateComparator);\ndef firstEventForGateway = eventsForGateway.get(0);def lastEventForGateway = eventsForGateway.get(eventsForGateway.size() - 1);eventAddedCount ++;\ndef newGateway = createNewGateway(possibleGateway.id, possibleGateway.type, \nfirstEventForGateway.endDate, lastEventForGateway.endDate, processInstanceId, definitionKey, eventAddedCount);\ncalculateAndAssignEventDuration(newGateway, dateFormatter);\ngatewayEventsToAdd.add(newGateway);\ngatewayCanBeAdded = !relatedEventsByFlowNodeId.values().stream().anyMatch(eventsForActivity -> eventsForActivity.isEmpty());\n}\n}\n}\n";
    }

    private static String createNewGatewayFunction() {
        return "def createNewGateway(def flowNodeId, def flowNodeType, def startDate, def endDate, def definitionKey, def processInstanceId, def eventAddedCount) {\ndef newGateway = [\n'flowNodeInstanceId': flowNodeId + '_' + eventAddedCount,\n'flowNodeId': flowNodeId,\n'flowNodeType': flowNodeType,\n'totalDurationInMs': 0,\n'startDate': startDate,\n'endDate': endDate,\n'processInstanceId': processInstanceId,\n'definitionKey': definitionKey,\n'definitionVersion': \"1\"\n];\nreturn newGateway;\n}\n";
    }
}

