/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.os;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.importing.DecisionInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableValueRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.DefinitionVariableLabelsDto;
import io.camunda.optimize.dto.optimize.query.variable.ExternalProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessToQueryDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableSourceDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableValuesQueryDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.es.schema.index.ProcessInstanceIndexES;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.OpenSearchCompositeAggregationScroller;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.ProcessQueryFilterEnhancerOS;
import io.camunda.optimize.service.db.os.schema.index.DecisionInstanceIndexOS;
import io.camunda.optimize.service.db.os.schema.index.ExternalProcessVariableIndexOS;
import io.camunda.optimize.service.db.os.schema.index.ProcessInstanceIndexOS;
import io.camunda.optimize.service.db.reader.DecisionDefinitionReader;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.repository.VariableRepository;
import io.camunda.optimize.service.db.repository.script.ProcessInstanceScriptFactory;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.db.schema.ScriptData;
import io.camunda.optimize.service.db.schema.index.AbstractInstanceIndex;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.util.DecisionVariableHelper;
import io.camunda.optimize.service.util.DefinitionQueryUtilOS;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregation;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregationSource;
import org.opensearch.client.opensearch._types.aggregations.CompositeBucket;
import org.opensearch.client.opensearch._types.aggregations.CompositeTermsAggregationSource;
import org.opensearch.client.opensearch._types.aggregations.DoubleTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.LongTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregation;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.MgetResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.opensearch.core.get.GetResult;
import org.opensearch.client.opensearch.core.mget.MultiGetOperation;
import org.opensearch.client.opensearch.core.mget.MultiGetResponseItem;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class VariableRepositoryOS
implements VariableRepository {
    private static final Logger LOG = LoggerFactory.getLogger(VariableRepositoryOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final OptimizeIndexNameService indexNameService;
    private final ConfigurationService configurationService;
    private final DateTimeFormatter dateTimeFormatter;
    private final DecisionDefinitionReader decisionDefinitionReader;
    private final ProcessDefinitionReader processDefinitionReader;
    private final ProcessQueryFilterEnhancerOS processQueryFilterEnhancer;

    public VariableRepositoryOS(OptimizeOpenSearchClient osClient, OptimizeIndexNameService indexNameService, ConfigurationService configurationService, DateTimeFormatter dateTimeFormatter, DecisionDefinitionReader decisionDefinitionReader, ProcessDefinitionReader processDefinitionReader, ProcessQueryFilterEnhancerOS processQueryFilterEnhancer) {
        this.osClient = osClient;
        this.indexNameService = indexNameService;
        this.configurationService = configurationService;
        this.dateTimeFormatter = dateTimeFormatter;
        this.decisionDefinitionReader = decisionDefinitionReader;
        this.processDefinitionReader = processDefinitionReader;
        this.processQueryFilterEnhancer = processQueryFilterEnhancer;
    }

    @Override
    public void deleteVariableDataByProcessInstanceIds(String processDefinitionKey, List<String> processInstanceIds) {
        List<BulkOperation> bulkOperations = processInstanceIds.stream().map(processInstanceId -> {
            UpdateOperation updateOperation = ((UpdateOperation.Builder)((UpdateOperation.Builder)new UpdateOperation.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex(InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)))).id(processInstanceId)).script(QueryDSL.script((String)ProcessInstanceScriptFactory.createVariableClearScript(), Map.of())).retryOnConflict(Integer.valueOf(5)).build();
            return (BulkOperation)new BulkOperation.Builder().update(updateOperation).build();
        }).toList();
        this.osClient.doBulkRequest(() -> new BulkRequest.Builder().refresh(Refresh.True), bulkOperations, InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey), false);
    }

    @Override
    public void upsertVariableLabel(String variableLabelIndexName, DefinitionVariableLabelsDto definitionVariableLabelsDto, ScriptData scriptData) {
        UpdateRequest.Builder updateRequest = new UpdateRequest.Builder().index(variableLabelIndexName).id(definitionVariableLabelsDto.getDefinitionKey().toLowerCase(Locale.ENGLISH)).scriptedUpsert(Boolean.valueOf(true)).script(QueryDSL.script((String)scriptData.scriptString(), (Map)scriptData.params())).retryOnConflict(Integer.valueOf(5)).refresh(Refresh.True).upsert((Object)definitionVariableLabelsDto);
        this.osClient.getRichOpenSearchClient().doc().upsert(updateRequest, DefinitionVariableLabelsDto.class, e -> String.format("Was not able to update the variable labels for the process definition with id: [%s]", definitionVariableLabelsDto.getDefinitionKey()));
    }

    @Override
    public void deleteVariablesForDefinition(String variableLabelIndexName, String processDefinitionKey) {
        this.osClient.delete(variableLabelIndexName, processDefinitionKey);
    }

    @Override
    public Map<String, DefinitionVariableLabelsDto> getVariableLabelsByKey(List<String> processDefinitionKeys) {
        List<MultiGetOperation> operations = processDefinitionKeys.stream().filter(Objects::nonNull).map(key -> new MultiGetOperation.Builder().id(key.toLowerCase(Locale.ENGLISH)).index(this.osClient.getIndexNameService().getOptimizeIndexAliasForIndex("variable-label")).build()).toList();
        String errorMessage = String.format("There was an error while fetching documents from the variable label index with keys %s.", processDefinitionKeys);
        MgetResponse response = this.osClient.mget(DefinitionVariableLabelsDto.class, errorMessage, operations);
        return response.docs().stream().map(MultiGetResponseItem::result).filter(GetResult::found).map(GetResult::source).filter(Objects::nonNull).peek(label -> label.setDefinitionKey(label.getDefinitionKey().toLowerCase(Locale.ENGLISH))).collect(Collectors.toMap(DefinitionVariableLabelsDto::getDefinitionKey, Function.identity()));
    }

    @Override
    public void writeExternalProcessVariables(List<ExternalProcessVariableDto> variables, String itemName) {
        List<BulkOperation> bulkOperations = variables.stream().map(this::createInsertExternalVariableOperation).toList();
        this.osClient.doBulkRequest(BulkRequest.Builder::new, bulkOperations, this.indexNameService.getOptimizeIndexAliasForIndex("external-process-variable"), false);
    }

    @Override
    public void deleteExternalVariablesIngestedBefore(OffsetDateTime evaluationDate, String deletedItemIdentifier) {
        this.osClient.deleteByQueryTask(deletedItemIdentifier, QueryDSL.lt((String)"ingestionTimestamp", (Object)this.dateTimeFormatter.format(evaluationDate)), false, new String[]{this.osClient.getIndexNameService().getOptimizeIndexNameWithVersionWithWildcardSuffix((IndexMappingCreator)new ExternalProcessVariableIndexOS())});
    }

    @Override
    public List<ExternalProcessVariableDto> getVariableUpdatesIngestedAfter(Long ingestTimestamp, int limit) {
        return this.getPageOfVariablesSortedByIngestionTimestamp(QueryDSL.gt((String)"ingestionTimestamp", (Object)ingestTimestamp), limit);
    }

    @Override
    public List<ExternalProcessVariableDto> getVariableUpdatesIngestedAt(Long ingestTimestamp) {
        return this.getPageOfVariablesSortedByIngestionTimestamp(QueryDSL.gteLte((String)"ingestionTimestamp", (Object)ingestTimestamp, (Object)ingestTimestamp), 10000);
    }

    @Override
    public List<String> getDecisionVariableValues(DecisionVariableValueRequestDto requestDto, String variablesPath) {
        Query query = DefinitionQueryUtilOS.createDefinitionQuery(requestDto.getDecisionDefinitionKey(), requestDto.getDecisionDefinitionVersions(), requestDto.getTenantIds(), (AbstractInstanceIndex)new DecisionInstanceIndexOS(requestDto.getDecisionDefinitionKey()), this.decisionDefinitionReader::getLatestVersionToKey);
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().index(InstanceIndexUtil.getDecisionInstanceIndexAliasName((String)requestDto.getDecisionDefinitionKey()), new String[0]).query(query).aggregations(this.getDecisionVariableValueAggregation(requestDto, variablesPath));
        try {
            String errorMsg = String.format("Was not able to fetch values for variable [%s] with type [%s] ", requestDto.getVariableId(), requestDto.getVariableType());
            SearchResponse searchResponse = this.osClient.search(searchRequest, DecisionInstanceDto.class, errorMsg);
            Map aggregations = searchResponse.aggregations();
            return this.extractVariableValues(aggregations, requestDto, variablesPath);
        }
        catch (RuntimeException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.DECISION, (RuntimeException)e)) {
                LOG.info("Was not able to fetch variable values because no instance index with alias {} exists. Returning empty list.", (Object)InstanceIndexUtil.getDecisionInstanceIndexAliasName((String)requestDto.getDecisionDefinitionKey()));
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public List<ProcessVariableNameResponseDto> getVariableNames(ProcessVariableNameRequestDto variableNameRequest, List<ProcessToQueryDto> validNameRequests, List<String> processDefinitionKeys, Map<String, DefinitionVariableLabelsDto> definitionLabelsDtos) {
        List<Query> definitionQueries = validNameRequests.stream().map(request -> DefinitionQueryUtilOS.createDefinitionQuery(request.getProcessDefinitionKey(), request.getProcessDefinitionVersions(), request.getTenantIds(), (AbstractInstanceIndex)new ProcessInstanceIndexES(request.getProcessDefinitionKey()), this.processDefinitionReader::getLatestVersionToKey)).toList();
        List<ProcessFilterDto<?>> processFilterDtos = variableNameRequest.getFilter().stream().filter(filter -> filter.getAppliedTo().contains("all")).toList();
        FilterContext filterContext = FilterContext.builder().timezone(variableNameRequest.getTimezone()).build();
        List<Query> filterQueries = this.processQueryFilterEnhancer.filterQueries(processFilterDtos, filterContext);
        BoolQuery.Builder query = new BoolQuery.Builder().minimumShouldMatch("1").should(definitionQueries).filter(filterQueries);
        return this.getVariableNamesForInstancesMatchingQuery(processDefinitionKeys, query, definitionLabelsDtos);
    }

    @Override
    public List<ProcessVariableNameResponseDto> getVariableNamesForInstancesMatchingQuery(List<String> processDefinitionKeysToTarget, Supplier<BoolQuery.Builder> baseQueryBuilderSupplier, Map<String, DefinitionVariableLabelsDto> definitionLabelsDtos) {
        LOG.debug("getVariableNamesForInstancesMatchingQuery: Functionality not implemented for OpenSearch");
        return List.of();
    }

    @Override
    public List<String> getVariableValues(ProcessVariableValuesQueryDto requestDto, List<ProcessVariableSourceDto> processVariableSources) {
        BoolQuery.Builder query = new BoolQuery.Builder();
        processVariableSources.forEach(source -> {
            query.should(DefinitionQueryUtilOS.createDefinitionQuery(source.getProcessDefinitionKey(), source.getProcessDefinitionVersions(), source.getTenantIds(), (AbstractInstanceIndex)new ProcessInstanceIndexOS(source.getProcessDefinitionKey()), this.processDefinitionReader::getLatestVersionToKey), new Query[0]);
            if (source.getProcessInstanceId() != null) {
                query.must(QueryDSL.term((String)"processInstanceId", (String)source.getProcessInstanceId()), new Query[0]);
            }
        });
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().query(query.build().toQuery()).size(Integer.valueOf(0)).aggregations(this.getVariableValueAggregation(requestDto)).index("process-instance", new String[0]);
        try {
            String errorMsg = String.format("Was not able to fetch values for variable [%s] with type [%s] ", requestDto.getName(), requestDto.getType().getId());
            SearchResponse searchResponse = this.osClient.search(searchRequest, ProcessInstanceDto.class, errorMsg);
            Map aggregations = searchResponse.aggregations();
            return this.extractVariableValues(aggregations, requestDto);
        }
        catch (RuntimeException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)e)) {
                LOG.info("Was not able to fetch variable values because no instance indices exist. Returning empty list.");
                return Collections.emptyList();
            }
            throw e;
        }
    }

    private List<String> extractVariableValues(Map<String, Aggregate> aggregations, DecisionVariableValueRequestDto requestDto, String variableFieldLabel) {
        return this.extractVariableValues(aggregations, requestDto.getResultOffset(), requestDto.getNumResults(), variableFieldLabel);
    }

    private List<String> extractVariableValues(Map<String, Aggregate> aggregations, ProcessVariableValuesQueryDto requestDto) {
        return this.extractVariableValues(aggregations, requestDto.getResultOffset(), requestDto.getNumResults(), "variables");
    }

    public List<ProcessVariableNameResponseDto> getVariableNamesForInstancesMatchingQuery(List<String> processDefinitionKeysToTarget, BoolQuery.Builder baseQuery, Map<String, DefinitionVariableLabelsDto> definitionLabelsDtos) {
        ArrayList<Map<String, CompositeAggregationSource>> variableNameAndTypeTerms = new ArrayList<Map<String, CompositeAggregationSource>>();
        variableNameAndTypeTerms.add(Collections.singletonMap("variableNameAggregation", new CompositeAggregationSource.Builder().terms(((CompositeTermsAggregationSource.Builder)new CompositeTermsAggregationSource.Builder().field(ProcessVariableHelper.getNestedVariableNameField())).build()).build()));
        variableNameAndTypeTerms.add(Collections.singletonMap("variableTypeAggregation", new CompositeAggregationSource.Builder().terms(((CompositeTermsAggregationSource.Builder)new CompositeTermsAggregationSource.Builder().field(ProcessVariableHelper.getNestedVariableTypeField())).build()).build()));
        variableNameAndTypeTerms.add(Collections.singletonMap("_index", new CompositeAggregationSource.Builder().terms(((CompositeTermsAggregationSource.Builder)new CompositeTermsAggregationSource.Builder().field("_index")).build()).build()));
        CompositeAggregation varNameAndTypeAgg = new CompositeAggregation.Builder().sources(variableNameAndTypeTerms).size(this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit()).build();
        NestedAggregation nestedAgg = new NestedAggregation.Builder().path("variables").build();
        Aggregation userTasksAgg = AggregationDSL.withSubaggregations((NestedAggregation)nestedAgg, Collections.singletonMap("varNameAndTypeCompositeAgg", varNameAndTypeAgg._toAggregation()));
        List<String> indicesToTarget = processDefinitionKeysToTarget.stream().map(InstanceIndexUtil::getProcessInstanceIndexAliasName).toList();
        ArrayList<ProcessVariableNameResponseDto> variableNames = new ArrayList<ProcessVariableNameResponseDto>();
        OpenSearchCompositeAggregationScroller compositeAggregationScroller = OpenSearchCompositeAggregationScroller.create().setClient(this.osClient).query(baseQuery.build().toQuery()).aggregations(Map.of("variables", userTasksAgg)).index(indicesToTarget).size(0).setPathToAggregation("variables", "varNameAndTypeCompositeAgg").setCompositeBucketConsumer(bucket -> variableNames.add(this.extractVariableNameAndLabel((CompositeBucket)bucket, definitionLabelsDtos)));
        compositeAggregationScroller.consumeAllPages();
        return this.filterVariableNameResults(variableNames);
    }

    private ProcessVariableNameResponseDto extractVariableNameAndLabel(CompositeBucket bucket, Map<String, DefinitionVariableLabelsDto> definitionLabelsByKey) {
        String processDefinitionKey = this.extractProcessDefinitionKeyFromIndexName((String)((JsonData)bucket.key().get("_index")).to(String.class));
        String variableName = (String)((JsonData)bucket.key().get("variableNameAggregation")).to(String.class);
        String variableType = (String)((JsonData)bucket.key().get("variableTypeAggregation")).to(String.class);
        return this.processVariableNameResponseDtoFrom(definitionLabelsByKey, processDefinitionKey, variableName, variableType);
    }

    private List<String> extractVariableValues(Map<String, Aggregate> aggregations, Integer resultOffset, Integer numResults, String variableFieldLabel) {
        NestedAggregate variablesFromType = aggregations.get(variableFieldLabel).nested();
        FilterAggregate filteredVariables = ((Aggregate)variablesFromType.aggregations().get("filteredVariables")).filter();
        ArrayList<String> allValues = new ArrayList<String>();
        if (((Aggregate)filteredVariables.aggregations().get("values")).isSterms()) {
            valueTerms = ((Aggregate)filteredVariables.aggregations().get("values")).sterms();
            for (StringTermsBucket valueBucket : valueTerms.buckets().array()) {
                allValues.add(valueBucket.key());
            }
        } else if (((Aggregate)filteredVariables.aggregations().get("values")).isDterms()) {
            valueTerms = ((Aggregate)filteredVariables.aggregations().get("values")).dterms();
            for (DoubleTermsBucket valueBucket : valueTerms.buckets().array()) {
                allValues.add(String.valueOf(valueBucket.key()));
            }
        } else if (((Aggregate)filteredVariables.aggregations().get("values")).isLterms()) {
            valueTerms = ((Aggregate)filteredVariables.aggregations().get("values")).lterms();
            for (LongTermsBucket valueBucket : valueTerms.buckets().array()) {
                if (valueBucket.keyAsString() != null) {
                    allValues.add(valueBucket.keyAsString());
                    continue;
                }
                allValues.add(String.valueOf(valueBucket.key()));
            }
        }
        int lastIndex = Math.min(allValues.size(), resultOffset + numResults);
        return allValues.subList(resultOffset, lastIndex);
    }

    private Map<String, Aggregation> getVariableValuesAggregation(String variablePath, VariableType variableType, Aggregation.Builder.ContainerBuilder filterForVariableWithGivenIdAndPrefix) {
        TermsAggregation collectAllVariableValues = new TermsAggregation.Builder().field(DecisionVariableHelper.getVariableValueFieldForType(variablePath, variableType)).size(Integer.valueOf(10000)).order(Map.of("_key", SortOrder.Asc), new Map[0]).build();
        filterForVariableWithGivenIdAndPrefix.aggregations(Map.of("values", collectAllVariableValues._toAggregation()));
        NestedAggregation.Builder nestedAgg = new NestedAggregation.Builder().path(variablePath);
        Aggregation finalAgg = new Aggregation.Builder().nested(nestedAgg.build()).aggregations(Map.of("filteredVariables", filterForVariableWithGivenIdAndPrefix.build())).build();
        return Map.of(variablePath, finalAgg);
    }

    private Map<String, Aggregation> getDecisionVariableValueAggregation(DecisionVariableValueRequestDto requestDto, String variablePath) {
        Aggregation.Builder.ContainerBuilder filterForVariableWithGivenIdAndPrefix = this.getVariableValueFilterAggregation(requestDto.getVariableId(), variablePath, requestDto.getValueFilter());
        return this.getVariableValuesAggregation(variablePath, requestDto.getVariableType(), filterForVariableWithGivenIdAndPrefix);
    }

    private Map<String, Aggregation> getVariableValueAggregation(ProcessVariableValuesQueryDto requestDto) {
        Aggregation.Builder.ContainerBuilder filterForVariableWithGivenIdAndPrefix = this.getVariableValueFilterAggregation(requestDto.getName(), requestDto.getType(), requestDto.getValueFilter());
        return this.getVariableValuesAggregation("variables", requestDto.getType(), filterForVariableWithGivenIdAndPrefix);
    }

    private Aggregation.Builder.ContainerBuilder getVariableValueFilterAggregation(String variableId, String variablePath, String valueFilter) {
        Query filterQuery = QueryDSL.term((String)DecisionVariableHelper.getVariableClauseIdField(variablePath), (String)variableId);
        filterQuery = this.addValueFilter(variablePath, valueFilter, filterQuery);
        return new Aggregation.Builder().filter(filterQuery);
    }

    private Aggregation.Builder.ContainerBuilder getVariableValueFilterAggregation(String variableName, VariableType type, String valueFilter) {
        Query filterQuery1 = QueryDSL.term((String)ProcessVariableHelper.getNestedVariableNameField(), (String)variableName);
        Query filterQuery2 = QueryDSL.term((String)ProcessVariableHelper.getNestedVariableTypeField(), (String)type.getId());
        Query filterQuery = this.addValueFilter(type, valueFilter, QueryDSL.and((Query[])new Query[]{filterQuery1, filterQuery2}));
        return new Aggregation.Builder().filter(filterQuery);
    }

    private Query addValueFilter(VariableType variableType, String valueFilter, Query filterQuery) {
        boolean valueFilterIsConfigured;
        boolean isStringVariable = VariableType.STRING.equals((Object)variableType);
        boolean bl = valueFilterIsConfigured = valueFilter != null && !valueFilter.isEmpty();
        if (isStringVariable && valueFilterIsConfigured) {
            String lowerCaseValue = valueFilter.toLowerCase(Locale.ENGLISH);
            Query filter = lowerCaseValue.length() > 10 ? QueryDSL.wildcardQuery((String)ProcessVariableHelper.getValueSearchField("lowercaseField"), (String)this.buildWildcardQuery(lowerCaseValue)) : QueryDSL.term((String)ProcessVariableHelper.getValueSearchField("nGramField"), (String)lowerCaseValue);
            return QueryDSL.and((Query[])new Query[]{filterQuery, filter});
        }
        return filterQuery;
    }

    private Query addValueFilter(String variablePath, String valueFilter, Query filterQuery) {
        if (valueFilter != null && !valueFilter.isEmpty()) {
            String lowerCaseValue = valueFilter.toLowerCase(Locale.ENGLISH);
            Query filter = lowerCaseValue.length() > 10 ? QueryDSL.wildcardQuery((String)this.getValueSearchField(variablePath, "lowercaseField"), (String)this.buildWildcardQuery(lowerCaseValue)) : QueryDSL.term((String)this.getValueSearchField(variablePath, "nGramField"), (String)lowerCaseValue);
            return QueryDSL.and((Query[])new Query[]{filterQuery, filter});
        }
        return filterQuery;
    }

    private List<ExternalProcessVariableDto> getPageOfVariablesSortedByIngestionTimestamp(Query query, int limit) {
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().query(query).index("external-process-variable", new String[0]).sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field("ingestionTimestamp").order(SortOrder.Asc).build()).build(), new SortOptions[0]).size(Integer.valueOf(limit));
        SearchResponse searchResponse = this.osClient.search(searchRequest, ExternalProcessVariableDto.class, "Was not able to retrieve ingested variables by timestamp!");
        return searchResponse.hits().hits().stream().map(Hit::source).collect(Collectors.toList());
    }

    private BulkOperation createInsertExternalVariableOperation(ExternalProcessVariableDto externalVariable) {
        IndexOperation indexOp = ((IndexOperation.Builder)new IndexOperation.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("external-process-variable"))).document((Object)externalVariable).build();
        return (BulkOperation)new BulkOperation.Builder().index(indexOp).build();
    }
}

