/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.os;

import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.service.db.es.schema.index.ProcessOverviewIndexES;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.repository.ProcessOverviewRepository;
import io.camunda.optimize.service.db.repository.script.ProcessOverviewScriptFactory;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessOverviewRepositoryOS
implements ProcessOverviewRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessOverviewRepositoryOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final OptimizeIndexNameService indexNameService;

    public ProcessOverviewRepositoryOS(OptimizeOpenSearchClient osClient, OptimizeIndexNameService indexNameService) {
        this.osClient = osClient;
        this.indexNameService = indexNameService;
    }

    @Override
    public void updateKpisForProcessDefinitions(List<ProcessOverviewDto> processOverviewDtos) {
        List<BulkOperation> bulkOperations = processOverviewDtos.stream().map(processOverviewDto -> (BulkOperation)new BulkOperation.Builder().update(((UpdateOperation.Builder)((UpdateOperation.Builder)new UpdateOperation.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("process-overview"))).id(processOverviewDto.getProcessDefinitionKey())).upsert(processOverviewDto).script(QueryDSL.script((String)ProcessOverviewScriptFactory.createUpdateKpisScript(), Map.of("lastKpiEvaluationResults", processOverviewDto.getLastKpiEvaluationResults()))).retryOnConflict(Integer.valueOf(5)).build()).build()).toList();
        this.osClient.doBulkRequest(BulkRequest.Builder::new, bulkOperations, new ProcessOverviewIndexES().getIndexName(), false);
    }

    @Override
    public void updateProcessConfiguration(String processDefinitionKey, ProcessOverviewDto overviewDto) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(Map.of("processDefinitionKey", overviewDto.getProcessDefinitionKey(), "digestEnabled", overviewDto.getDigest().isEnabled()));
        if (overviewDto.getOwner() != null) {
            params.put("owner", (Boolean)((Object)overviewDto.getOwner()));
        }
        UpdateRequest.Builder requestBuilder = new UpdateRequest.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("process-overview")).id(processDefinitionKey).script(QueryDSL.script((String)ProcessOverviewScriptFactory.createUpdateOverviewScript(), params)).upsert((Object)overviewDto).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5));
        this.osClient.upsert(requestBuilder, ProcessOverviewDto.class, e -> String.format("There was a problem while updating the process: [%s].", overviewDto));
    }

    @Override
    public void updateProcessDigestResults(String processDefKey, ProcessDigestDto processDigestDto) {
        Map<String, Map> params = Map.of("kpiReportResults", processDigestDto.getKpiReportResults());
        UpdateRequest.Builder requestBuilder = new UpdateRequest.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("process-overview")).id(processDefKey).script(QueryDSL.script((String)ProcessOverviewScriptFactory.createUpdateProcessDigestScript(), params)).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5));
        this.osClient.update(requestBuilder, e -> String.format("There was a problem while updating the digest results for process with key: [%s] and digest results: %s.", processDefKey, processDigestDto.getKpiReportResults()));
    }

    @Override
    public void updateProcessOwnerIfNotSet(String processDefinitionKey, String ownerId, ProcessOverviewDto processOverviewDto) {
        Map<String, String> params = Map.of("owner", ownerId, "processDefinitionKey", processDefinitionKey);
        UpdateRequest.Builder requestBuilder = new UpdateRequest.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("process-overview")).id(processDefinitionKey).script(QueryDSL.script((String)ProcessOverviewScriptFactory.createUpdateOwnerIfNotSetScript(), params)).upsert((Object)processOverviewDto).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5));
        this.osClient.upsert(requestBuilder, ProcessOverviewDto.class, e -> String.format("There was a problem while updating the owner for process with key: [%s] and owner ID: %s.", processDefinitionKey, ownerId));
    }

    @Override
    public void deleteProcessOwnerEntry(String processDefinitionKey) {
        this.osClient.delete(this.indexNameService.getOptimizeIndexAliasForIndex("process-overview"), processDefinitionKey);
    }
}

