/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.os;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ImportRequestDto;
import io.camunda.optimize.dto.optimize.query.PageResultDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.repository.ProcessInstanceRepository;
import io.camunda.optimize.service.db.repository.script.ProcessInstanceScriptFactory;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
class ProcessInstanceRepositoryOS
implements ProcessInstanceRepository {
    public static final String INDEX_NOT_FOUND_ERROR_MESSAGE_KEYWORD = "index_not_found_exception";
    private static final Logger LOG = LoggerFactory.getLogger(ProcessInstanceRepositoryOS.class);
    private final ConfigurationService configurationService;
    private final OptimizeIndexNameService indexNameService;
    private final OptimizeOpenSearchClient osClient;
    private final ObjectMapper objectMapper;
    private final DateTimeFormatter dateTimeFormatter;

    public ProcessInstanceRepositoryOS(ConfigurationService configurationService, OptimizeIndexNameService indexNameService, OptimizeOpenSearchClient osClient, ObjectMapper objectMapper, DateTimeFormatter dateTimeFormatter) {
        this.configurationService = configurationService;
        this.indexNameService = indexNameService;
        this.osClient = osClient;
        this.objectMapper = objectMapper;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public void deleteByIds(String index, String itemName, List<String> processInstanceIds) {
        List<BulkOperation> bulkOperations = processInstanceIds.stream().map(id -> BulkOperation.of(op -> op.delete(d -> (ObjectBuilder)((DeleteOperation.Builder)d.index(this.osClient.convertToPrefixedAliasName(index))).id(id)))).toList();
        this.osClient.doBulkRequest(BulkRequest.Builder::new, bulkOperations, itemName, false);
    }

    @Override
    public void bulkImport(String bulkRequestName, List<ImportRequestDto> importRequests) {
        this.osClient.executeImportRequestsAsBulk(bulkRequestName, importRequests, this.configurationService.getSkipDataAfterNestedDocLimitReached());
    }

    @Override
    public boolean processDefinitionHasStartedInstances(String processDefinitionKey) {
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex(InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)), new String[0]).query(QueryDSL.exists((String)"startDate")).source(QueryDSL.sourceInclude((String[])new String[]{"processInstanceId"})).size(Integer.valueOf(1));
        try {
            return this.osClient.search(requestBuilder, Object.class, "Failed querying for started process instances!").hits().total().value() > 0L;
        }
        catch (OpenSearchException e) {
            return false;
        }
    }

    @Override
    public PageResultDto<String> getNextPageOfProcessInstanceIds(PageResultDto<String> previousPage, Supplier<PageResultDto<String>> firstPageFetchFunction) {
        int limit = previousPage.getLimit();
        if (previousPage.isLastPage()) {
            return new PageResultDto<String>(limit);
        }
        try {
            PageResultDto<String> pageResult = new PageResultDto<String>(limit);
            String currentScrollId = previousPage.getPagingState();
            boolean limitReached = false;
            List<Object> processInstanceIds = List.of();
            do {
                if (pageResult.getEntities().size() < limit) {
                    record Result(String processInstanceId) {
                    }
                    ScrollResponse response = this.osClient.scroll(currentScrollId, this.scrollTimeout(), Result.class);
                    currentScrollId = response.scrollId();
                    processInstanceIds = response.hits().hits().stream().map(hit -> ((Result)hit.source()).processInstanceId()).toList();
                    pageResult.getEntities().addAll(processInstanceIds.subList(0, Math.min(response.hits().hits().size(), limit - pageResult.getEntities().size())));
                    pageResult.setPagingState(currentScrollId);
                    continue;
                }
                limitReached = true;
            } while (!limitReached && !processInstanceIds.isEmpty());
            if (pageResult.getEntities().isEmpty() || pageResult.getEntities().size() < limit) {
                this.osClient.clearScroll(currentScrollId, e -> String.format("Could not clear scroll for class [%s], since Opensearch was unable to perform the action!", this.getClass().getSimpleName()));
                pageResult.setPagingState(null);
            }
            return pageResult;
        }
        catch (OpenSearchException e2) {
            if (HttpStatus.NOT_FOUND.value() == e2.response().status().intValue()) {
                return firstPageFetchFunction.get();
            }
            throw e2;
        }
        catch (IOException e3) {
            String reason = String.format("Could not close scroll for class [%s].", this.getClass().getSimpleName());
            LOG.error(reason, (Throwable)e3);
            throw new OptimizeRuntimeException(reason, (Throwable)e3);
        }
    }

    @Override
    public PageResultDto<String> getFirstPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore(String processDefinitionKey, OffsetDateTime endDate, Integer limit) {
        return this.getFirstPageOfProcessInstanceIdsForFilter(processDefinitionKey, QueryDSL.and((Query[])new Query[]{QueryDSL.lt((String)"endDate", (Object)this.dateTimeFormatter.format(endDate)), QueryDSL.nested((String)"variables", (Query)QueryDSL.exists((String)"variables.id"), (ChildScoreMode)ChildScoreMode.None)}), limit);
    }

    @Override
    public PageResultDto<String> getFirstPageOfProcessInstanceIdsThatEndedBefore(String processDefinitionKey, OffsetDateTime endDate, Integer limit) {
        return this.getFirstPageOfProcessInstanceIdsForFilter(processDefinitionKey, QueryDSL.lt((String)"endDate", (Object)this.dateTimeFormatter.format(endDate)), limit);
    }

    private PageResultDto<String> getFirstPageOfProcessInstanceIdsForFilter(String processDefinitionKey, Query filterQuery, Integer limit) {
        PageResultDto<String> result = new PageResultDto<String>(limit);
        Integer resolvedLimit = Optional.ofNullable(limit).orElse(10000);
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex(InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)), new String[0]).scroll(builder -> builder.time(this.scrollTimeout())).query(filterQuery).source(QueryDSL.sourceInclude((String[])new String[]{"processInstanceId"})).size(Integer.valueOf(resolvedLimit <= 10000 ? resolvedLimit : 10000));
        try {
            record Result(String processInstanceId) {
            }
            SearchResponse response = this.osClient.search(requestBuilder, Result.class, "Could not obtain process instance ids.");
            List<String> processInstanceIds = response.hits().hits().stream().map(hit -> ((Result)hit.source()).processInstanceId()).toList();
            if (!processInstanceIds.isEmpty()) {
                result.getEntities().addAll(processInstanceIds.subList(0, Math.min(response.hits().hits().size(), resolvedLimit)));
            }
            result.setPagingState(response.scrollId());
        }
        catch (OpenSearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to obtain process instance IDs because instance index {} does not exist. Returning empty result.", (Object)InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey));
                result.setPagingState(null);
                return result;
            }
            throw e;
        }
        return result;
    }

    private String scrollTimeout() {
        return String.format("%ss", this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds());
    }

    private Script createUpdateStateScript(String newState) {
        Map<String, JsonData> scriptParameters = this.createUpdateStateScriptParamsMap(newState);
        return OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams(ProcessInstanceScriptFactory.createInlineUpdateScript(), scriptParameters);
    }

    private Map<String, JsonData> createUpdateStateScriptParamsMap(String newState) {
        return Map.of("activeState", QueryDSL.json((Object)"ACTIVE"), "suspendedState", QueryDSL.json((Object)"SUSPENDED"), "newState", QueryDSL.json((Object)newState));
    }

    private String aliasForProcessDefinitionKey(String processDefinitionKey) {
        return this.indexNameService.getOptimizeIndexAliasForIndex(InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey));
    }
}

