/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.os;

import io.camunda.optimize.dto.optimize.importing.DecisionInstanceDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.repository.DecisionInstanceRepository;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DecisionInstanceRepositoryOS
implements DecisionInstanceRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionInstanceRepositoryOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;
    private final OptimizeIndexNameService indexNameService;
    private final DateTimeFormatter dateTimeFormatter;

    public DecisionInstanceRepositoryOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService, OptimizeIndexNameService indexNameService, DateTimeFormatter dateTimeFormatter) {
        this.osClient = osClient;
        this.configurationService = configurationService;
        this.indexNameService = indexNameService;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public void importDecisionInstances(String importItemName, List<DecisionInstanceDto> decisionInstanceDtos) {
        this.osClient.doImportBulkRequestWithList(importItemName, decisionInstanceDtos, this::addImportDecisionInstanceRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached());
    }

    @Override
    public void deleteDecisionInstancesByDefinitionKeyAndEvaluationDateOlderThan(String decisionDefinitionKey, OffsetDateTime evaluationDate) {
        String deleteItemIdentifier = String.format("decision instances with definitionKey %s and evaluationDate past %s", decisionDefinitionKey, evaluationDate);
        this.osClient.deleteByQueryTask(deleteItemIdentifier, QueryDSL.lt((String)"evaluationDateTime", (Object)this.dateTimeFormatter.format(evaluationDate)), true, new String[]{this.aliasForDecisionDefinitionKey(decisionDefinitionKey)});
    }

    private BulkOperation addImportDecisionInstanceRequest(DecisionInstanceDto decisionInstanceDto) {
        String decisionInstanceId = decisionInstanceDto.getDecisionInstanceId();
        IndexOperation indexOperation = ((IndexOperation.Builder)((IndexOperation.Builder)new IndexOperation.Builder().index(this.aliasForDecisionDefinitionKey(decisionInstanceDto.getDecisionDefinitionKey()))).id(decisionInstanceId)).document((Object)decisionInstanceDto).build();
        return (BulkOperation)new BulkOperation.Builder().index(indexOperation).build();
    }

    private String aliasForDecisionDefinitionKey(String decisionDefinitionKey) {
        return this.indexNameService.getOptimizeIndexAliasForIndex(InstanceIndexUtil.getDecisionInstanceIndexAliasName((String)decisionDefinitionKey));
    }
}

