/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeDeleteRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateOperationBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateRequestBuilderES;
import io.camunda.optimize.service.db.es.schema.index.ProcessOverviewIndexES;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import io.camunda.optimize.service.db.repository.ProcessOverviewRepository;
import io.camunda.optimize.service.db.repository.script.ProcessOverviewScriptFactory;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessOverviewRepositoryES
implements ProcessOverviewRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessOverviewRepositoryES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;

    public ProcessOverviewRepositoryES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public void updateKpisForProcessDefinitions(List<ProcessOverviewDto> processOverviewDtos) {
        BulkRequest bulkRequest = processOverviewDtos.isEmpty() ? null : BulkRequest.of(b -> {
            processOverviewDtos.forEach(processOverviewDto -> b.operations(o -> o.update(OptimizeUpdateOperationBuilderES.of(u -> ((UpdateOperation.Builder)u.optimizeIndex(this.esClient, "process-overview").id(processOverviewDto.getProcessDefinitionKey())).action(a -> a.upsert(processOverviewDto).script(ElasticsearchWriterUtil.createDefaultScriptWithPrimitiveParams(ProcessOverviewScriptFactory.createUpdateKpisScript(), Map.of("lastKpiEvaluationResults", processOverviewDto.getLastKpiEvaluationResults())))).retryOnConflict(Integer.valueOf(5))))));
            return b;
        });
        this.esClient.doBulkRequest(bulkRequest, new ProcessOverviewIndexES().getIndexName(), false);
    }

    @Override
    public void updateProcessConfiguration(String processDefinitionKey, ProcessOverviewDto overviewDto) {
        try {
            HashMap<String, JsonData> paramMap = new HashMap<String, JsonData>();
            if (overviewDto.getOwner() != null) {
                paramMap.put("owner", JsonData.of((Object)overviewDto.getOwner()));
            }
            paramMap.put("processDefinitionKey", JsonData.of((Object)overviewDto.getProcessDefinitionKey()));
            paramMap.put("digestEnabled", JsonData.of((Object)overviewDto.getDigest().isEnabled()));
            UpdateRequest updateRequest = OptimizeUpdateRequestBuilderES.of(u -> u.optimizeIndex(this.esClient, new String[]{"process-overview"}).id(processDefinitionKey).script(Script.of(s -> s.lang(ScriptLanguage.Painless).source(ProcessOverviewScriptFactory.createUpdateOverviewScript()).params(paramMap))).upsert((Object)overviewDto).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5)));
            this.esClient.update(updateRequest, ProcessOverviewDto.class);
        }
        catch (Exception e) {
            String errorMessage = String.format("There was a problem while updating the process: [%s].", overviewDto);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void updateProcessDigestResults(String processDefKey, ProcessDigestDto processDigestDto) {
        try {
            UpdateRequest updateRequest = OptimizeUpdateRequestBuilderES.of(u -> u.optimizeIndex(this.esClient, new String[]{"process-overview"}).id(processDefKey).script(Script.of(s -> s.lang(ScriptLanguage.Painless).source(ProcessOverviewScriptFactory.createUpdateProcessDigestScript()).params(Map.of("kpiReportResults", JsonData.of((Object)processDigestDto.getKpiReportResults()))))).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5)));
            this.esClient.update(updateRequest, ProcessDigestDto.class);
        }
        catch (Exception e) {
            String errorMessage = String.format("There was a problem while updating the digest results for process with key: [%s] and digest results: %s.", processDefKey, processDigestDto.getKpiReportResults());
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void updateProcessOwnerIfNotSet(String processDefinitionKey, String ownerId, ProcessOverviewDto processOverviewDto) {
        try {
            UpdateRequest updateRequestBuilder = OptimizeUpdateRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"process-overview"}).id(processDefinitionKey).script(ElasticsearchWriterUtil.createDefaultScriptWithPrimitiveParams(ProcessOverviewScriptFactory.createUpdateOwnerIfNotSetScript(), Map.of("owner", ownerId, "processDefinitionKey", processDefinitionKey))).upsert((Object)processOverviewDto).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5)));
            this.esClient.update(updateRequestBuilder, ProcessOverviewDto.class);
        }
        catch (Exception e) {
            String errorMessage = String.format("There was a problem while updating the owner for process with key: [%s] and owner ID: %s.", processDefinitionKey, ownerId);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void deleteProcessOwnerEntry(String processDefinitionKey) {
        try {
            this.esClient.delete(OptimizeDeleteRequestBuilderES.of(d -> d.optimizeIndex(this.esClient, "process-overview").id(processDefinitionKey)));
        }
        catch (IOException e) {
            String errorMessage = String.format("There was a problem while deleting process owner entry for %s", processDefinitionKey);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
    }
}

