/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.util.ObjectBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ImportRequestDto;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.PageResultDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.repository.ProcessInstanceRepository;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
class ProcessInstanceRepositoryES
implements ProcessInstanceRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessInstanceRepositoryES.class);
    private final ConfigurationService configurationService;
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;
    private final DateTimeFormatter dateTimeFormatter;
    private final TaskRepositoryES taskRepositoryES;

    public ProcessInstanceRepositoryES(ConfigurationService configurationService, OptimizeElasticsearchClient esClient, ObjectMapper objectMapper, DateTimeFormatter dateTimeFormatter, TaskRepositoryES taskRepositoryES) {
        this.configurationService = configurationService;
        this.esClient = esClient;
        this.objectMapper = objectMapper;
        this.dateTimeFormatter = dateTimeFormatter;
        this.taskRepositoryES = taskRepositoryES;
    }

    @Override
    public void deleteByIds(String index, String itemName, List<String> processInstanceIds) {
        BulkRequest bulkRequest = BulkRequest.of(b -> b.operations(processInstanceIds.stream().map(id -> BulkOperation.of(o -> o.delete(d -> (ObjectBuilder)((DeleteOperation.Builder)d.id(id)).index((String)this.esClient.addPrefixesToIndices(new String[]{index}).get(0))))).toList()));
        this.esClient.doBulkRequest(bulkRequest, index, false);
    }

    @Override
    public void bulkImport(String bulkRequestName, List<ImportRequestDto> importRequests) {
        this.esClient.executeImportRequestsAsBulk(bulkRequestName, importRequests, this.configurationService.getSkipDataAfterNestedDocLimitReached());
    }

    @Override
    public boolean processDefinitionHasStartedInstances(String processDefinitionKey) {
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)}).query(q -> q.bool(bb -> bb.filter(f -> f.exists(e -> e.field("startDate"))))).size(Integer.valueOf(1)).source(s -> s.filter(f -> f.includes("processInstanceId", new String[0]))));
        try {
            SearchResponse response = this.esClient.search(searchRequest, Object.class);
            return !response.hits().hits().isEmpty();
        }
        catch (ElasticsearchException e) {
            return false;
        }
        catch (IOException e2) {
            LOG.warn("Error with ElasticSearch thrown while querying for started process instances, returning false! The error was: " + e2.getMessage());
            return false;
        }
    }

    @Override
    public PageResultDto<String> getNextPageOfProcessInstanceIds(PageResultDto<String> previousPage, Supplier<PageResultDto<String>> firstPageFetchFunction) {
        if (previousPage.isLastPage()) {
            return new PageResultDto<String>(previousPage.getLimit());
        }
        try {
            return ElasticsearchReaderUtil.retrieveNextScrollResultsPage(previousPage.getPagingState(), String.class, searchHit -> ((ProcessInstanceDto)this.objectMapper.convertValue(searchHit.source(), ProcessInstanceDto.class)).getProcessInstanceId(), this.esClient, this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds(), previousPage.getLimit());
        }
        catch (ElasticsearchException e) {
            if (e.status() == HttpResponseStatus.NOT_FOUND.code()) {
                return firstPageFetchFunction.get();
            }
            throw e;
        }
    }

    @Override
    public PageResultDto<String> getFirstPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore(String processDefinitionKey, OffsetDateTime endDate, Integer limit) {
        return this.getFirstPageOfProcessInstanceIdsForFilter(processDefinitionKey, BoolQuery.of(b -> b.filter(q -> q.range(r -> r.date(df -> (ObjectBuilder)df.field("endDate").lt((Object)this.dateTimeFormatter.format(endDate))))).filter(f -> f.nested(n -> n.path("variables").scoreMode(ChildScoreMode.None).query(q -> q.exists(e -> e.field("variables.id")))))), limit);
    }

    @Override
    public PageResultDto<String> getFirstPageOfProcessInstanceIdsThatEndedBefore(String processDefinitionKey, OffsetDateTime endDate, Integer limit) {
        return this.getFirstPageOfProcessInstanceIdsForFilter(processDefinitionKey, BoolQuery.of(b -> b.filter(q -> q.range(r -> r.date(df -> (ObjectBuilder)df.field("endDate").lt((Object)this.dateTimeFormatter.format(endDate)))))), limit);
    }

    private PageResultDto<String> getFirstPageOfProcessInstanceIdsForFilter(String processDefinitionKey, BoolQuery filterQuery, Integer limit) {
        PageResultDto<String> result = new PageResultDto<String>(limit);
        Integer resolvedLimit = Optional.ofNullable(limit).orElse(10000);
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)}).query(q -> q.bool(filterQuery)).source(s -> s.filter(f -> f.includes(List.of("processInstanceId")))).scroll(Time.of(t -> t.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s"))).size(Integer.valueOf(resolvedLimit <= 10000 ? resolvedLimit : 10000)));
        try {
            SearchResponse response = this.esClient.search(searchRequest, Map.class);
            result.getEntities().addAll(ElasticsearchReaderUtil.mapHits(response.hits(), resolvedLimit, String.class, searchHit -> ((Map)searchHit.source()).get("processInstanceId").toString()));
            result.setPagingState(response.scrollId());
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Could not obtain process instance ids.", (Throwable)e);
        }
        catch (ElasticsearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to obtain process instance IDs because instance index {} does not exist. Returning empty result.", (Object)InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey));
                result.setPagingState(null);
                return result;
            }
            throw e;
        }
        return result;
    }

    private ImmutableMap<String, String> createUpdateStateScriptParamsMap(String newState) {
        return ImmutableMap.of((Object)"activeState", (Object)"ACTIVE", (Object)"suspendedState", (Object)"SUSPENDED", (Object)"newState", (Object)newState);
    }
}

