/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.result;

import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.MeasureDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.ResultType;
import io.camunda.optimize.service.export.CSVUtils;
import java.time.ZoneId;
import java.util.LinkedList;
import java.util.List;

public class NumberCommandResult
extends CommandEvaluationResult<Double> {
    public NumberCommandResult(SingleReportDataDto reportData) {
        super((ReportDataDto)reportData);
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
    }

    public NumberCommandResult(List<MeasureDto<Double>> measures, SingleReportDataDto reportData) {
        super(measures, (ReportDataDto)reportData);
        if (measures == null) {
            throw new IllegalArgumentException("measures cannot be null");
        }
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
    }

    public NumberCommandResult(long instanceCount, long instanceCountWithoutFilters, List<MeasureDto<Double>> measures, SingleReportDataDto reportData) {
        super(instanceCount, instanceCountWithoutFilters, measures, (ReportDataDto)reportData);
        if (measures == null) {
            throw new IllegalArgumentException("measures cannot be null");
        }
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
    }

    @Override
    public List<String[]> getResultAsCsv(Integer limit, Integer offset, ZoneId timezone) {
        if (this.getReportDataAs(SingleReportDataDto.class).getViewProperties().contains(ViewProperty.FREQUENCY)) {
            return this.frequencyNumberAsCsv();
        }
        return this.durationNumberAsCsv();
    }

    @Override
    public ResultType getType() {
        return ResultType.NUMBER;
    }

    private List<String[]> frequencyNumberAsCsv() {
        LinkedList<String[]> csvStrings = new LinkedList<String[]>();
        csvStrings.add(new String[]{String.valueOf(this.getFirstMeasureData())});
        String normalizedCommandKey = this.getViewIdentifier(this.getReportDataAs(SingleReportDataDto.class));
        String[] header = new String[]{normalizedCommandKey};
        csvStrings.add(0, header);
        return csvStrings;
    }

    private List<String[]> durationNumberAsCsv() {
        LinkedList<String[]> csvStrings = new LinkedList<String[]>();
        Double result = (Double)this.getFirstMeasureData();
        csvStrings.add(new String[]{String.valueOf(result)});
        SingleReportDataDto singleReportData = this.getReportDataAs(SingleReportDataDto.class);
        String normalizedCommandKey = this.getViewIdentifier(singleReportData);
        String[] operations = new String[]{CSVUtils.mapAggregationType((AggregationDto)singleReportData.getConfiguration().getAggregationTypes().iterator().next())};
        csvStrings.add(0, operations);
        String[] header = new String[]{normalizedCommandKey};
        csvStrings.add(0, header);
        return csvStrings;
    }
}

