/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.view.process.duration;

import io.camunda.optimize.dto.optimize.query.report.single.configuration.process_part.ProcessPartDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.aggregations.AggregationStrategy;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.math3.util.Precision;

public final class ProcessViewDurationInterpreterHelper {
    private ProcessViewDurationInterpreterHelper() {
    }

    public static ProcessPartDto getProcessPart(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return (ProcessPartDto)context.getReportConfiguration().getProcessPart().orElseThrow(() -> new OptimizeRuntimeException("Missing ProcessPart"));
    }

    public static <AGGREGATION_STRATEGY extends AggregationStrategy> CompositeCommandResult.ViewResult retrieveResult(List<AGGREGATION_STRATEGY> aggregationStrategies, Function<AGGREGATION_STRATEGY, Double> measureExtractor) {
        CompositeCommandResult.ViewResult.ViewResultBuilder viewResultBuilder = CompositeCommandResult.ViewResult.builder();
        aggregationStrategies.forEach(aggregationStrategy -> {
            Double measureResult = (Double)measureExtractor.apply(aggregationStrategy);
            if (measureResult != null) {
                measureResult = Precision.round((double)measureResult, (int)0);
            }
            viewResultBuilder.viewMeasure(CompositeCommandResult.ViewMeasure.builder().aggregationType(aggregationStrategy.getAggregationType()).value(measureResult).build());
        });
        return viewResultBuilder.build();
    }
}

