/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.view.decision;

import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.TableColumnDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.InputVariableEntry;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.OutputVariableEntry;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.RawDataDecisionInstanceDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.reader.DecisionVariableReader;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.util.RawDecisionDataResultDtoMapper;
import io.camunda.optimize.service.db.report.interpreter.view.decision.DecisionViewInterpreter;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionView;
import io.camunda.optimize.service.export.CSVUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractDecisionViewRawDataInterpreter
implements DecisionViewInterpreter {
    public static final String INPUT_VARIABLE_PREFIX = "inputVariable:";
    public static final String OUTPUT_VARIABLE_PREFIX = "outputVariable:";
    protected final RawDecisionDataResultDtoMapper rawDataSingleReportResultDtoMapper = new RawDecisionDataResultDtoMapper();

    @Override
    public Set<DecisionView> getSupportedViews() {
        return Set.of(DecisionView.DECISION_VIEW_RAW_DATA);
    }

    protected abstract DecisionVariableReader getDecisionVariableReader();

    protected Set<InputVariableEntry> getInputVariableEntries(SingleReportDataDto reportDataDto) {
        return this.getDecisionVariableReader().getInputVariableNames(reportDataDto.getDefinitionKey(), reportDataDto.getDefinitionVersions(), DefinitionService.prepareTenantListForDefinitionSearch(reportDataDto.getTenantIds())).stream().map(inputVar -> new InputVariableEntry(inputVar.getId(), inputVar.getName(), inputVar.getType(), null)).collect(Collectors.toSet());
    }

    protected Set<OutputVariableEntry> getOutputVars(SingleReportDataDto reportDataDto) {
        return this.getDecisionVariableReader().getOutputVariableNames(reportDataDto.getDefinitionKey(), reportDataDto.getDefinitionVersions(), DefinitionService.prepareTenantListForDefinitionSearch(reportDataDto.getTenantIds())).stream().map(outputVar -> new OutputVariableEntry(outputVar.getId(), outputVar.getName(), outputVar.getType(), Collections.emptyList())).collect(Collectors.toSet());
    }

    protected void addNewVariablesAndDtoFieldsToTableColumnConfig(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context, List<RawDataDecisionInstanceDto> rawData) {
        List variableNames = rawData.stream().flatMap(rawDataDecisionInstanceDto -> rawDataDecisionInstanceDto.getInputVariables().values().stream()).map(this::getPrefixedInputVariableId).collect(Collectors.toList());
        variableNames.addAll(rawData.stream().flatMap(rawDataDecisionInstanceDto -> rawDataDecisionInstanceDto.getOutputVariables().values().stream()).map(this::getPrefixedOutputVariableId).toList());
        TableColumnDto tableColumns = context.getReportConfiguration().getTableColumns();
        tableColumns.addNewAndRemoveUnexpectedVariableColumns(variableNames);
        tableColumns.addDtoColumns(CSVUtils.extractAllDecisionInstanceDtoFieldKeys());
    }

    protected String getPrefixedInputVariableId(InputVariableEntry inputVariableEntry) {
        return "input:" + inputVariableEntry.getId();
    }

    protected String getPrefixedOutputVariableId(OutputVariableEntry outputVariableEntry) {
        return "output:" + outputVariableEntry.getId();
    }
}

