/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.plan;

import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.interpreter.plan.decision.DecisionExecutionPlanInterpreterFacade;
import io.camunda.optimize.service.db.report.interpreter.plan.process.ProcessExecutionPlanInterpreterFacade;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ExecutionPlanInterpreterFacade {
    private final ProcessExecutionPlanInterpreterFacade processExecutionPlanInterpreterFacade;
    private final DecisionExecutionPlanInterpreterFacade decisionExecutionPlanInterpreterFacade;

    public ExecutionPlanInterpreterFacade(ProcessExecutionPlanInterpreterFacade processExecutionPlanInterpreterFacade, DecisionExecutionPlanInterpreterFacade decisionExecutionPlanInterpreterFacade) {
        this.processExecutionPlanInterpreterFacade = processExecutionPlanInterpreterFacade;
        this.decisionExecutionPlanInterpreterFacade = decisionExecutionPlanInterpreterFacade;
    }

    public CommandEvaluationResult<Object> interpret(ExecutionContext<? extends SingleReportDataDto, ? extends ExecutionPlan> context) {
        if (context.getPlan() instanceof DecisionExecutionPlan && context.getReportData() instanceof DecisionReportDataDto) {
            ExecutionContext<? extends SingleReportDataDto, ? extends ExecutionPlan> decisionExecutionContext = context;
            return this.decisionExecutionPlanInterpreterFacade.interpret(decisionExecutionContext);
        }
        if (context.getPlan() instanceof ProcessExecutionPlan && context.getReportData() instanceof ProcessReportDataDto) {
            ExecutionContext<? extends SingleReportDataDto, ? extends ExecutionPlan> processExecutionContext = context;
            return this.processExecutionPlanInterpreterFacade.interpret(processExecutionContext);
        }
        throw new UnsupportedOperationException(String.format("No interpreter registred for plan=%s, context=%s", context.getPlan(), context));
    }

    public Optional<MinMaxStatDto> getGroupByMinMaxStats(ExecutionContext context) {
        if (context.getPlan() instanceof ProcessExecutionPlan && context.getReportData() instanceof ProcessReportDataDto) {
            ExecutionContext processExecutionContext = context;
            return this.processExecutionPlanInterpreterFacade.getGroupByMinMaxStats(processExecutionContext);
        }
        return Optional.empty();
    }
}

