/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.groupby.usertask;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.UserTaskDurationTime;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.distributedby.DistributedByInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ProcessGroupByUserTaskInterpreterHelper {
    private final DefinitionService definitionService;

    public ProcessGroupByUserTaskInterpreterHelper(DefinitionService definitionService) {
        this.definitionService = definitionService;
    }

    public void addMissingGroupByResults(Map<String, String> userTaskNames, List<CompositeCommandResult.GroupByResult> groupedData, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, DistributedByInterpreter distributedByInterpreter) {
        boolean viewLevelFilterExists = context.getReportData().getFilter().stream().anyMatch(filter -> FilterApplicationLevel.VIEW.equals((Object)filter.getFilterLevel()));
        if (!viewLevelFilterExists) {
            userTaskNames.forEach((key, value) -> groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(key, value, distributedByInterpreter.createEmptyResult(context))));
        }
    }

    public void removeHiddenModelElements(List<CompositeCommandResult.GroupByResult> groupedData, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        if (context.getHiddenFlowNodeIds() != null) {
            groupedData.removeIf(dataPoint -> context.getHiddenFlowNodeIds().contains(dataPoint.getKey()));
        }
    }

    public Map<String, String> getUserTaskNames(ProcessReportDataDto reportData) {
        return this.definitionService.extractUserTaskIdAndNames(reportData.getDefinitions().stream().map(definitionDto -> this.definitionService.getDefinition(DefinitionType.PROCESS, definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds())).filter(Optional::isPresent).map(Optional::get).map(ProcessDefinitionOptimizeDto.class::cast).collect(Collectors.toList()));
    }

    public UserTaskDurationTime getUserTaskDurationTime(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return context.getReportConfiguration().getUserTaskDurationTimes().stream().findFirst().orElse(UserTaskDurationTime.TOTAL);
    }
}

