/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.filter.util;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.RelativeDateFilterStartDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.RollingDateFilterStartDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.instance.FixedDateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.instance.RelativeDateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.instance.RollingDateFilterDataDto;
import io.camunda.optimize.service.util.DateFilterUtil;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class DateHistogramFilterUtil {
    public static OffsetDateTime getMaxDateFilterOffsetDateTime(List<DateFilterDataDto<?>> dateFilters) {
        return dateFilters.stream().map(DateFilterDataDto::getEnd).filter(Objects::nonNull).max(OffsetDateTime::compareTo).orElse(OffsetDateTime.now());
    }

    public static Optional<OffsetDateTime> getMinDateFilterOffsetDateTime(List<DateFilterDataDto<?>> dateFilters) {
        OffsetDateTime now = OffsetDateTime.now();
        Stream[] streamArray = new Stream[3];
        streamArray[0] = dateFilters.stream().filter(FixedDateFilterDataDto.class::isInstance).map(date -> (OffsetDateTime)date.getStart()).filter(Objects::nonNull);
        streamArray[1] = dateFilters.stream().filter(RollingDateFilterDataDto.class::isInstance).map(filter -> {
            RollingDateFilterStartDto startDto = (RollingDateFilterStartDto)filter.getStart();
            ChronoUnit filterUnit = ChronoUnit.valueOf(startDto.getUnit().name());
            return now.minus(startDto.getValue(), filterUnit);
        });
        streamArray[2] = dateFilters.stream().filter(RelativeDateFilterDataDto.class::isInstance).map(filter -> {
            RelativeDateFilterStartDto startDto = (RelativeDateFilterStartDto)((RelativeDateFilterDataDto)filter).getStart();
            OffsetDateTime startOfCurrentInterval = DateFilterUtil.getStartOfCurrentInterval(now, startDto.getUnit());
            if (startDto.getValue() == 0L) {
                return startOfCurrentInterval;
            }
            return DateFilterUtil.getStartOfPreviousInterval(startOfCurrentInterval, startDto.getUnit(), startDto.getValue());
        });
        return Stream.of(streamArray).flatMap(stream -> stream).min(OffsetDateTime::compareTo);
    }
}

