/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report;

import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.service.db.report.ExecutionPlanExtractor;
import io.camunda.optimize.service.db.report.ReportEvaluationContext;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import java.util.List;
import java.util.stream.Stream;

public abstract class CombinedReportInstanceCounter<A> {
    public abstract long count(List<SingleProcessReportDefinitionRequestDto> var1);

    protected abstract ExecutionPlanExtractor getExecutionPlanExtractor();

    protected abstract A getBaseQuery(ProcessExecutionPlan var1, ReportEvaluationContext<SingleProcessReportDefinitionRequestDto> var2);

    private Stream<ReportEvaluationContext<SingleProcessReportDefinitionRequestDto>> getAllReportEvaluationContexts(List<SingleProcessReportDefinitionRequestDto> singleReportDefinitions) {
        return singleReportDefinitions.stream().map(reportDefinition -> {
            ReportEvaluationContext<SingleProcessReportDefinitionRequestDto> reportEvaluationContext = new ReportEvaluationContext<SingleProcessReportDefinitionRequestDto>();
            reportEvaluationContext.setReportDefinition((SingleProcessReportDefinitionRequestDto)reportDefinition);
            return reportEvaluationContext;
        });
    }

    protected List<A> getAllBaseQueries(List<SingleProcessReportDefinitionRequestDto> singleReportDefinitions) {
        return this.getAllReportEvaluationContexts(singleReportDefinitions).map(reportEvaluationContext -> {
            ExecutionPlan plan = this.getExecutionPlanExtractor().extractExecutionPlans((SingleProcessReportDefinitionRequestDto)reportEvaluationContext.getReportDefinition()).get(0);
            if (plan instanceof ProcessExecutionPlan) {
                ProcessExecutionPlan processExecutionPlan = (ProcessExecutionPlan)plan;
                return this.getBaseQuery(processExecutionPlan, (ReportEvaluationContext<SingleProcessReportDefinitionRequestDto>)reportEvaluationContext);
            }
            throw new UnsupportedOperationException("CombinedReportInstanceCounter.getAllBaseQueries is defined only for process execution plans. Provided: " + String.valueOf(plan));
        }).toList();
    }
}

