/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import io.camunda.optimize.dto.optimize.DecisionDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.query.definition.DefinitionWithTenantIdsDto;
import io.camunda.optimize.dto.optimize.query.definition.TenantIdWithDefinitionsDto;
import io.camunda.optimize.dto.optimize.rest.DefinitionVersionResponseDto;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public interface DefinitionReader {
    public static final String VERSION_AGGREGATION = "versions";
    public static final String VERSION_TAG_AGGREGATION = "versionTags";
    public static final String TENANT_AGGREGATION = "tenants";
    public static final String ENGINE_AGGREGATION = "engines";
    public static final String TOP_HITS_AGGREGATION = "topHits";
    public static final String DEFINITION_KEY_FILTER_AGGREGATION = "definitionKeyFilter";
    public static final String DEFINITION_TYPE_AGGREGATION = "definitionType";
    public static final String DEFINITION_KEY_AGGREGATION = "definitionKey";
    public static final String DEFINITION_KEY_AND_TYPE_AGGREGATION = "definitionKeyAndType";
    public static final String DEFINITION_KEY_AND_TYPE_AND_TENANT_AGGREGATION = "definitionKeyAndTypeAndTenant";
    public static final String NAME_AGGREGATION = "definitionName";
    public static final String[] ALL_DEFINITION_INDEXES = new String[]{"process-definition", "decision-definition"};
    public static final String TENANT_NOT_DEFINED_VALUE = "null";

    public Optional<DefinitionWithTenantIdsDto> getDefinitionWithAvailableTenants(DefinitionType var1, String var2);

    public Optional<DefinitionWithTenantIdsDto> getDefinitionWithAvailableTenants(DefinitionType var1, String var2, List<String> var3, Supplier<String> var4);

    public List<DefinitionWithTenantIdsDto> getFullyImportedDefinitionsWithTenantIds(DefinitionType var1, Set<String> var2, Set<String> var3);

    public <T extends DefinitionOptimizeResponseDto> List<T> getFullyImportedDefinitions(DefinitionType var1, boolean var2);

    public <T extends DefinitionOptimizeResponseDto> Optional<T> getFirstFullyImportedDefinitionFromTenantsIfAvailable(DefinitionType var1, String var2, List<String> var3, List<String> var4);

    public <T extends DefinitionOptimizeResponseDto> List<T> getLatestFullyImportedDefinitionsFromTenantsIfAvailable(DefinitionType var1, String var2);

    public Set<String> getDefinitionEngines(DefinitionType var1, String var2);

    public Map<String, TenantIdWithDefinitionsDto> getDefinitionsGroupedByTenant();

    public String getLatestVersionToKey(DefinitionType var1, String var2);

    public List<DefinitionVersionResponseDto> getDefinitionVersions(DefinitionType var1, String var2, Set<String> var3);

    public <T extends DefinitionOptimizeResponseDto> List<T> getDefinitions(DefinitionType var1, boolean var2, boolean var3, boolean var4);

    public <T extends DefinitionOptimizeResponseDto> List<T> getDefinitions(DefinitionType var1, Set<String> var2, boolean var3, boolean var4, boolean var5);

    default public String[] resolveIndexNameForType(DefinitionType type) {
        String[] stringArray;
        if (type == null) {
            return ALL_DEFINITION_INDEXES;
        }
        switch (type) {
            case PROCESS: {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "process-definition";
                break;
            }
            case DECISION: {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "decision-definition";
                break;
            }
            default: {
                throw new OptimizeRuntimeException("Unsupported definition type:" + String.valueOf(type));
            }
        }
        return stringArray;
    }

    default public String resolveXmlFieldFromType(DefinitionType type) {
        return switch (type) {
            case DefinitionType.PROCESS -> "bpmn20Xml";
            case DefinitionType.DECISION -> "dmn10Xml";
            default -> throw new IllegalStateException("Unknown DefinitionType:" + String.valueOf(type));
        };
    }

    default public String resolveVersionFieldFromType(DefinitionType type) {
        return switch (type) {
            case DefinitionType.PROCESS -> "version";
            case DefinitionType.DECISION -> "version";
            default -> throw new IllegalStateException("Unknown DefinitionType:" + String.valueOf(type));
        };
    }

    default public String resolveDefinitionKeyFieldFromType(DefinitionType type) {
        return switch (type) {
            case DefinitionType.PROCESS -> "key";
            case DefinitionType.DECISION -> "key";
            default -> throw new IllegalStateException("Unknown DefinitionType:" + String.valueOf(type));
        };
    }

    default public <T extends DefinitionOptimizeResponseDto> Class<T> resolveDefinitionClassFromType(DefinitionType type) {
        if (Objects.isNull(type)) {
            return DefinitionOptimizeResponseDto.class;
        }
        return switch (type) {
            case DefinitionType.PROCESS -> ProcessDefinitionOptimizeDto.class;
            case DefinitionType.DECISION -> DecisionDefinitionOptimizeDto.class;
            default -> throw new IllegalStateException("Unknown DefinitionType:" + String.valueOf(type));
        };
    }
}

