/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import io.camunda.optimize.service.db.reader.BackupReader;
import io.camunda.optimize.service.exceptions.OptimizeConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackupReader
implements BackupReader {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBackupReader.class);

    @Override
    public void validateRepositoryExists() {
        if (StringUtils.isEmpty((CharSequence)this.getSnapshotRepositoryName())) {
            String reason = "Cannot execute backup request because no snapshot repository name found in Optimize configuration.";
            LOG.error("Cannot execute backup request because no snapshot repository name found in Optimize configuration.");
            throw new OptimizeConfigurationException("Cannot execute backup request because no snapshot repository name found in Optimize configuration.");
        }
        this.validateRepositoryExistsOrFail();
    }

    protected abstract String getSnapshotRepositoryName();

    protected abstract void validateRepositoryExistsOrFail();
}

