/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.camunda.optimize.dto.optimize.DecisionDefinitionOptimizeDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.writer.DecisionDefinitionWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DecisionDefinitionWriterOS
implements DecisionDefinitionWriter {
    private static final Script MARK_AS_DELETED_SCRIPT = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("ctx._source.deleted = true", Collections.emptyMap());
    private static final Logger LOG = LoggerFactory.getLogger(DecisionDefinitionWriterOS.class);
    private final ObjectMapper objectMapper;
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;

    public DecisionDefinitionWriterOS(ObjectMapper objectMapper, OptimizeOpenSearchClient osClient, ConfigurationService configurationService) {
        this.objectMapper = objectMapper;
        this.osClient = osClient;
        this.configurationService = configurationService;
    }

    @Override
    public void importDecisionDefinitions(List<DecisionDefinitionOptimizeDto> decisionDefinitionOptimizeDtos) {
        LOG.debug("Writing [{}] decision definitions to opensearch", (Object)decisionDefinitionOptimizeDtos.size());
        this.writeDecisionDefinitionInformation(decisionDefinitionOptimizeDtos);
    }

    @Override
    public void markDefinitionAsDeleted(String definitionId) {
        LOG.debug("Marking decision definition with ID {} as deleted", (Object)definitionId);
        UpdateRequest.Builder updateRequest = new UpdateRequest.Builder().index("decision-definition").id(definitionId).script(MARK_AS_DELETED_SCRIPT).retryOnConflict(Integer.valueOf(5));
        String errorMessage = String.format("There was a problem when trying to mark decision definition with ID %s as deleted", definitionId);
        this.osClient.update(updateRequest, errorMessage);
    }

    @Override
    public boolean markRedeployedDefinitionsAsDeleted(List<DecisionDefinitionOptimizeDto> importedDefinitions) {
        AtomicBoolean definitionsUpdated = new AtomicBoolean(false);
        Lists.partition(importedDefinitions, (int)100).forEach(partition -> {
            BoolQuery.Builder definitionsToDeleteQuery = new BoolQuery.Builder();
            partition.forEach(definition -> {
                BoolQuery.Builder matchingDefinitionQuery = new BoolQuery.Builder().must(QueryDSL.term((String)"key", (String)definition.getKey()), new Query[0]).must(QueryDSL.term((String)"version", (String)definition.getVersion()), new Query[0]).mustNot(QueryDSL.term((String)"id", (String)definition.getId()), new Query[0]);
                if (definition.getTenantId() != null) {
                    matchingDefinitionQuery.must(QueryDSL.term((String)"tenantId", (String)definition.getTenantId()), new Query[0]);
                } else {
                    matchingDefinitionQuery.mustNot(QueryDSL.exists((String)"tenantId"), new Query[0]);
                }
                definitionsToDeleteQuery.should(matchingDefinitionQuery.build().toQuery(), new Query[0]);
            });
            long markedAsDeleted = this.osClient.updateByQuery("decision-definition", definitionsToDeleteQuery.build().toQuery(), MARK_AS_DELETED_SCRIPT);
            if (markedAsDeleted > 0L && !definitionsUpdated.get()) {
                definitionsUpdated.set(true);
            }
        });
        if (definitionsUpdated.get()) {
            LOG.debug("Marked old decision definitions with new deployments as deleted");
        }
        return definitionsUpdated.get();
    }

    private void writeDecisionDefinitionInformation(List<DecisionDefinitionOptimizeDto> decisionDefinitionOptimizeDtos) {
        String importItemName = "decision definition information";
        LOG.debug("Writing [{}] {} to OS.", (Object)decisionDefinitionOptimizeDtos.size(), (Object)"decision definition information");
        this.osClient.doImportBulkRequestWithList("decision definition information", decisionDefinitionOptimizeDtos, this::addImportDecisionDefinitionRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached(), "decision-definition");
    }

    private BulkOperation addImportDecisionDefinitionRequest(DecisionDefinitionOptimizeDto decisionDefinitionDto) {
        Script updateScript = OpenSearchWriterUtil.createFieldUpdateScript(FIELDS_TO_UPDATE, decisionDefinitionDto, this.objectMapper);
        UpdateOperation updateOperation = ((UpdateOperation.Builder)new UpdateOperation.Builder().id(decisionDefinitionDto.getId())).script(updateScript).upsert((Object)decisionDefinitionDto).retryOnConflict(Integer.valueOf(5)).build();
        return (BulkOperation)new BulkOperation.Builder().update(updateOperation).build();
    }
}

