/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Conditional(value={OpenSearchCondition.class})
public abstract class AbstractProcessDefinitionWriterOS {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper objectMapper;
    protected final OptimizeOpenSearchClient osClient;

    public AbstractProcessDefinitionWriterOS(ObjectMapper objectMapper, OptimizeOpenSearchClient osClient) {
        this.objectMapper = objectMapper;
        this.osClient = osClient;
    }

    abstract Script createUpdateScript(ProcessDefinitionOptimizeDto var1);

    public BulkOperation addImportProcessDefinitionToRequest(ProcessDefinitionOptimizeDto processDefinitionDto) {
        Script updateScript = this.createUpdateScript(processDefinitionDto);
        UpdateOperation request = ((UpdateOperation.Builder)new UpdateOperation.Builder().id(processDefinitionDto.getId())).script(updateScript).upsert((Object)processDefinitionDto).retryOnConflict(Integer.valueOf(5)).build();
        return (BulkOperation)new BulkOperation.Builder().update(request).build();
    }
}

