/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.usertask;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.DistributedByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.usertask.AbstractGroupByUserTaskInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.ViewInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.groupby.usertask.ProcessGroupByUserTaskInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.SingleBucketAggregateBase;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessGroupByUserTaskInterpreterOS
extends AbstractGroupByUserTaskInterpreterOS {
    private static final String USER_TASK_ID_TERMS_AGGREGATION = "userTaskIds";
    private final ConfigurationService configurationService;
    private final DefinitionService definitionService;
    private final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;
    private final ProcessViewInterpreterFacadeOS viewInterpreter;
    private final ProcessGroupByUserTaskInterpreterHelper helper;

    public ProcessGroupByUserTaskInterpreterOS(ConfigurationService configurationService, DefinitionService definitionService, ProcessDistributedByInterpreterFacadeOS distributedByInterpreter, ProcessViewInterpreterFacadeOS viewInterpreter, ProcessGroupByUserTaskInterpreterHelper helper) {
        this.configurationService = configurationService;
        this.definitionService = definitionService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
        this.helper = helper;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_USER_TASK);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Aggregation aggregation = Aggregation.of(a -> {
            Aggregation.Builder.ContainerBuilder terms = a.terms(t -> t.field("flowNodeInstances.flowNodeId").size(this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit()));
            this.distributedByInterpreter.createAggregations(context, boolQuery).forEach((arg_0, arg_1) -> ((Aggregation.Builder.ContainerBuilder)terms).aggregations(arg_0, arg_1));
            return terms;
        });
        return this.createFilteredUserTaskAggregation(context, boolQuery, USER_TASK_ID_TERMS_AGGREGATION, aggregation);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        this.getFilteredUserTaskAggregation(response).map(filteredFlowNodes -> ((Aggregate)filteredFlowNodes.aggregations().get(USER_TASK_ID_TERMS_AGGREGATION)).sterms()).ifPresent(userTasksAggregation -> {
            this.getUserTasksAggregation(response).map(SingleBucketAggregateBase::aggregations).ifPresent(userTaskSubAggregations -> this.distributedByInterpreter.enrichContextWithAllExpectedDistributedByKeys(context, (Map<String, Aggregate>)userTaskSubAggregations));
            Map<String, String> userTaskNames = this.getHelper().getUserTaskNames((ProcessReportDataDto)context.getReportData());
            ArrayList<CompositeCommandResult.GroupByResult> groupedData = new ArrayList<CompositeCommandResult.GroupByResult>();
            for (StringTermsBucket b : userTasksAggregation.buckets().array()) {
                String userTaskKey = b.key();
                if (!userTaskNames.containsKey(userTaskKey)) continue;
                List<CompositeCommandResult.DistributedByResult> singleResult = this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)b.aggregations(), context);
                String label = userTaskNames.get(userTaskKey);
                groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(userTaskKey, label, singleResult));
                userTaskNames.remove(userTaskKey);
            }
            this.getHelper().addMissingGroupByResults(userTaskNames, groupedData, context, this.distributedByInterpreter);
            this.getHelper().removeHiddenModelElements(groupedData, context);
            compositeCommandResult.setGroupBySorting(context.getReportConfiguration().getSorting().orElseGet(() -> new ReportSortingDto(null, SortOrder.ASC)));
            compositeCommandResult.setGroups(groupedData);
        });
    }

    @Override
    protected DistributedByInterpreterOS<ProcessReportDataDto, ProcessExecutionPlan> getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    @Override
    protected ViewInterpreterOS<ProcessReportDataDto, ProcessExecutionPlan> getViewInterpreter() {
        return this.viewInterpreter;
    }

    @Override
    protected DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    @Override
    public ProcessGroupByUserTaskInterpreterHelper getHelper() {
        return this.helper;
    }
}

