/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.flownode;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.flownode.AbstractGroupByFlowNodeInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.groupby.flownode.ProcessGroupByFlowNodeInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessGroupByFlowNodeInterpreterOS
extends AbstractGroupByFlowNodeInterpreterOS {
    private static final String NESTED_EVENTS_AGGREGATION = "nestedEvents";
    private final ConfigurationService configurationService;
    private final ProcessGroupByFlowNodeInterpreterHelper helper;
    private final DefinitionService definitionService;
    private final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;
    private final ProcessViewInterpreterFacadeOS viewInterpreter;

    public ProcessGroupByFlowNodeInterpreterOS(ConfigurationService configurationService, ProcessGroupByFlowNodeInterpreterHelper helper, DefinitionService definitionService, ProcessDistributedByInterpreterFacadeOS distributedByInterpreter, ProcessViewInterpreterFacadeOS viewInterpreter) {
        this.configurationService = configurationService;
        this.helper = helper;
        this.definitionService = definitionService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_FLOW_NODE);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        int size = this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit();
        Aggregation aggregation = new Aggregation.Builder().terms(AggregationDSL.termAggregation((String)"flowNodeInstances.flowNodeId", (int)size)).aggregations(this.distributedByInterpreter.createAggregations(context, query)).build();
        return this.createFilteredFlowNodeAggregation(context, Map.of(NESTED_EVENTS_AGGREGATION, aggregation));
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        this.getFilteredFlowNodesAggregation(response).map(filteredFlowNodes -> ((Aggregate)filteredFlowNodes.aggregations().get(NESTED_EVENTS_AGGREGATION)).sterms()).ifPresent(byFlowNodeIdAggregation -> {
            Map<String, String> flowNodeNames = this.helper.getFlowNodeNames((ProcessReportDataDto)context.getReportData());
            ArrayList<CompositeCommandResult.GroupByResult> groupedData = new ArrayList<CompositeCommandResult.GroupByResult>();
            for (StringTermsBucket flowNodeBucket : byFlowNodeIdAggregation.buckets().array()) {
                String flowNodeKey = flowNodeBucket.key();
                if (!flowNodeNames.containsKey(flowNodeKey)) continue;
                List<CompositeCommandResult.DistributedByResult> singleResult = this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)flowNodeBucket.aggregations(), context);
                String label = flowNodeNames.get(flowNodeKey);
                groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(flowNodeKey, label, singleResult));
                flowNodeNames.remove(flowNodeKey);
            }
            this.helper.addMissingGroupByKeys(flowNodeNames, groupedData, context, this.distributedByInterpreter.createEmptyResult(context));
            this.helper.removeHiddenModelElements(groupedData, context);
            compositeCommandResult.setGroups(groupedData);
        });
    }

    public ProcessDistributedByInterpreterFacadeOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

