/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.date;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.rest.util.TimeZoneUtil;
import io.camunda.optimize.service.db.os.report.context.DateAggregationContextOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.service.DateAggregationServiceOS;
import io.camunda.optimize.service.db.os.report.service.MinMaxStatsServiceOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.DateAggregationContext;
import io.camunda.optimize.service.db.report.interpreter.groupby.process.date.ProcessGroupByProcessInstanceRunningDateInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.util.types.MapUtil;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FiltersAggregate;
import org.opensearch.client.opensearch._types.aggregations.FiltersBucket;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessGroupByProcessInstanceRunningDateInterpreterOS
extends AbstractProcessGroupByInterpreterOS {
    private final DateTimeFormatter formatter;
    private final DateAggregationServiceOS dateAggregationService;
    private final MinMaxStatsServiceOS minMaxStatsService;
    private final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;
    private final ProcessViewInterpreterFacadeOS viewInterpreter;

    public ProcessGroupByProcessInstanceRunningDateInterpreterOS(DateTimeFormatter formatter, DateAggregationServiceOS dateAggregationService, MinMaxStatsServiceOS minMaxStatsService, ProcessDistributedByInterpreterFacadeOS distributedByInterpreter, ProcessViewInterpreterFacadeOS viewInterpreter) {
        this.formatter = formatter;
        this.dateAggregationService = dateAggregationService;
        this.minMaxStatsService = minMaxStatsService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_PROCESS_INSTANCE_RUNNING_DATE);
    }

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return ProcessGroupByProcessInstanceRunningDateInterpreter.getMinMaxStats(context, () -> this.minMaxStatsService.getMinMaxDateRangeForCrossField(context, baseQuery, this.getIndexNames(context), "startDate", "endDate"));
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        MinMaxStatDto minMaxStats = this.minMaxStatsService.getMinMaxDateRangeForCrossField(context, query, this.getIndexNames(context), "startDate", "endDate");
        DateAggregationContext dateAggContext = ((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)DateAggregationContextOS.builder().aggregateByDateUnit(ProcessGroupByProcessInstanceRunningDateInterpreter.getGroupByDateUnit(context.getReportData()))).minMaxStats(minMaxStats)).dateField("startDate")).runningDateReportEndDateField("endDate")).timezone(context.getTimezone())).subAggregations(this.getDistributedByInterpreter().createAggregations(context, query))).filterContext(context.getFilterContext())).build();
        return this.dateAggregationService.createRunningDateAggregation((DateAggregationContextOS)dateAggContext).map(MapUtil::createFromPair).orElse(Map.of());
    }

    @Override
    protected void addQueryResult(CompositeCommandResult result, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        if (response.aggregations() != null) {
            ProcessGroupByProcessInstanceRunningDateInterpreter.addQueryResult(result, this.processAggregations(response, response.aggregations(), context), context);
        }
    }

    private List<CompositeCommandResult.GroupByResult> processAggregations(SearchResponse<RawResult> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        if (!aggregations.containsKey("filterLimitedAggregation")) {
            return List.of();
        }
        FiltersAggregate agg = aggregations.get("filterLimitedAggregation").filters();
        return agg.buckets().keyed().entrySet().stream().map(entry -> {
            String key = TimeZoneUtil.formatToCorrectTimezone((String)entry.getKey(), context.getTimezone(), this.formatter);
            List<CompositeCommandResult.DistributedByResult> distributions = this.getDistributedByInterpreter().retrieveResult(response, (Map<String, Aggregate>)((FiltersBucket)entry.getValue()).aggregations(), context);
            return CompositeCommandResult.GroupByResult.createGroupByResult(key, distributions);
        }).toList();
    }

    public ProcessDistributedByInterpreterFacadeOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

