/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.date;

import io.camunda.optimize.dto.optimize.query.report.single.configuration.DistributedByType;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.value.DateGroupByValueDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.value.ProcessGroupByValueDto;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.context.DateAggregationContextOS;
import io.camunda.optimize.service.db.os.report.filter.ProcessQueryFilterEnhancerOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.FilterLimitedAggregationUtilOS;
import io.camunda.optimize.service.db.os.report.service.DateAggregationServiceOS;
import io.camunda.optimize.service.db.os.report.service.MinMaxStatsServiceOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.DateAggregationContext;
import io.camunda.optimize.service.db.report.groupby.ProcessGroupByProcessInstanceDateInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.util.types.MapUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;

public abstract class AbstractProcessGroupByProcessInstanceDateInterpreterOS
extends AbstractProcessGroupByInterpreterOS {
    protected abstract ConfigurationService getConfigurationService();

    protected abstract DateAggregationServiceOS getDateAggregationService();

    protected abstract MinMaxStatsServiceOS getMinMaxStatsService();

    protected abstract ProcessQueryFilterEnhancerOS getQueryFilterEnhancer();

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        DateGroupByValueDto groupByDate;
        ProcessGroupByValueDto processGroupByValueDto = context.getReportData().getGroupBy().getValue();
        if (processGroupByValueDto instanceof DateGroupByValueDto && AggregateByDateUnit.AUTOMATIC.equals((Object)(groupByDate = (DateGroupByValueDto)processGroupByValueDto).getUnit())) {
            return Optional.of(this.getMinMaxDateStats(context, baseQuery));
        }
        return Optional.empty();
    }

    @Override
    public void adjustSearchRequest(SearchRequest.Builder searchRequestBuilder, Query baseQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        super.adjustSearchRequest(searchRequestBuilder, baseQuery, context);
        searchRequestBuilder.query(QueryDSL.and((Query[])new Query[]{baseQuery, QueryDSL.exists((String)this.getDateField())}));
    }

    public abstract String getDateField();

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        AggregateByDateUnit unit = this.getGroupByDateUnit(context.getReportData());
        return this.createAggregation(query, context, unit);
    }

    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, AggregateByDateUnit unit) {
        MinMaxStatDto stats = this.getMinMaxDateStats(context, query);
        DateAggregationContext dateAggContext = ((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)DateAggregationContextOS.builder().aggregateByDateUnit(unit)).dateField(this.getDateField())).minMaxStats(stats)).timezone(context.getTimezone())).subAggregations(this.getDistributedByInterpreter().createAggregations(context, query))).processGroupByType(context.getReportData().getGroupBy().getType())).processFilters(context.getReportData().getFilter())).processQueryFilterEnhancer(this.getQueryFilterEnhancer())).filterContext(context.getFilterContext())).build();
        return this.getDateAggregationService().createProcessInstanceDateAggregation((DateAggregationContextOS)dateAggContext).map(agg -> this.addSiblingAggregationIfRequired(context, query, (Pair<String, Aggregation>)agg)).map(MapUtil::createFromPair).orElse(Map.of());
    }

    private MinMaxStatDto getMinMaxDateStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return this.getMinMaxStatsService().getMinMaxDateRange(context, baseQuery, this.getIndexNames(context), this.getDateField());
    }

    @Override
    public void addQueryResult(CompositeCommandResult result, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        ProcessGroupByProcessInstanceDateInterpreter.addQueryResult(this.processAggregations(response, response.aggregations(), context), this.getDistributedByInterpreter().isKeyOfNumericType(context), result, context);
    }

    private List<CompositeCommandResult.GroupByResult> processAggregations(SearchResponse<RawResult> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        if (aggregations == null) {
            return Collections.emptyList();
        }
        return FilterLimitedAggregationUtilOS.unwrapFilterLimitedAggregations(aggregations).map(unwrappedLimitedAggregations -> {
            Map<String, Map<String, Aggregate>> keyToAggregationMap = this.getDateAggregationService().mapDateAggregationsToKeyAggregationMap((Map<String, Aggregate>)unwrappedLimitedAggregations, context.getTimezone());
            this.getDistributedByInterpreter().enrichContextWithAllExpectedDistributedByKeys(context, (Map<String, Aggregate>)unwrappedLimitedAggregations);
            return this.mapKeyToAggMapToGroupByResults(keyToAggregationMap, response, context);
        }).orElse(Collections.emptyList());
    }

    private List<CompositeCommandResult.GroupByResult> mapKeyToAggMapToGroupByResults(Map<String, Map<String, Aggregate>> keyToAggregationMap, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return keyToAggregationMap.entrySet().stream().map(stringBucketEntry -> CompositeCommandResult.GroupByResult.createGroupByResult((String)stringBucketEntry.getKey(), this.getDistributedByInterpreter().retrieveResult(response, (Map)stringBucketEntry.getValue(), context))).toList();
    }

    private AggregateByDateUnit getGroupByDateUnit(ProcessReportDataDto processReportData) {
        return ((DateGroupByValueDto)processReportData.getGroupBy().getValue()).getUnit();
    }

    private DistributedByType getDistributedByType(ProcessReportDataDto processReportDataDto) {
        return processReportDataDto.getDistributedBy().getType();
    }

    private Pair<String, Aggregation> addSiblingAggregationIfRequired(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery, Pair<String, Aggregation> aggregation) {
        if (DistributedByType.VARIABLE.equals((Object)this.getDistributedByType(context.getReportData()))) {
            Map subAggregations = MapUtil.combineUniqueMaps((Map)((Aggregation)aggregation.getValue()).aggregations(), this.getDistributedByInterpreter().createAggregations(context, baseQuery));
            return Pair.of((Object)((String)aggregation.getKey()), (Object)AggregationDSL.withSubaggregations((Aggregation)((Aggregation)aggregation.getValue()), (Map)subAggregations));
        }
        return aggregation;
    }
}

