/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.date;

import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.value.DateGroupByValueDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.service.db.os.report.context.DateAggregationContextOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.FilterLimitedAggregationUtilOS;
import io.camunda.optimize.service.db.os.report.service.DateAggregationServiceOS;
import io.camunda.optimize.service.db.os.report.service.MinMaxStatsServiceOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.DateAggregationContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.util.types.MapUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;

public abstract class AbstractProcessGroupByModelElementDateInterpreterOS
extends AbstractProcessGroupByInterpreterOS {
    private static final String ELEMENT_AGGREGATION = "elementAggregation";
    private static final String FILTERED_ELEMENTS_AGGREGATION = "filteredElements";
    private static final String MODEL_ELEMENT_TYPE_FILTER_AGGREGATION = "filteredElementsByType";

    protected abstract DateAggregationServiceOS getDateAggregationService();

    protected abstract MinMaxStatsServiceOS getMinMaxStatsService();

    protected abstract String getPathToElementField();

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        AggregateByDateUnit unit = this.getGroupByDateUnit(context.getReportData());
        MinMaxStatDto stats = this.getMinMaxStatsService().getMinMaxDateRangeForNestedField(context, query, this.getIndexNames(context), this.getDateField(), this.getPathToElementField(), this.getFilterBoolQuery(context));
        DateAggregationContext dateAggContext = ((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)DateAggregationContextOS.builder().aggregateByDateUnit(unit)).dateField(this.getDateField())).minMaxStats(stats)).timezone(context.getTimezone())).subAggregations(this.getDistributedByInterpreter().createAggregations(context, query))).filterContext(context.getFilterContext())).build();
        Optional<Pair<String, Aggregation>> bucketLimitedHistogramAggregation = this.getDateAggregationService().createModelElementDateAggregation((DateAggregationContextOS)dateAggContext);
        return bucketLimitedHistogramAggregation.map(agg -> this.wrapInNestedElementAggregation(context, (Pair<String, Aggregation>)agg, this.getDistributedByInterpreter().createAggregations(context, query))).orElseGet(Map::of);
    }

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        AggregateByDateUnit groupByDateUnit;
        if (context.getReportData().getGroupBy().getValue() instanceof DateGroupByValueDto && AggregateByDateUnit.AUTOMATIC.equals((Object)(groupByDateUnit = this.getGroupByDateUnit(context.getReportData())))) {
            return Optional.of(this.getMinMaxStatsService().getMinMaxDateRangeForNestedField(context, baseQuery, this.getIndexNames(context), this.getDateField(), this.getPathToElementField(), this.getFilterBoolQuery(context)));
        }
        return Optional.empty();
    }

    @Override
    public void addQueryResult(CompositeCommandResult result, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        result.setGroups(this.processAggregations(response, context));
        result.setGroupBySorting(context.getReportConfiguration().getSorting().orElseGet(() -> new ReportSortingDto("key", SortOrder.ASC)));
    }

    private Map<String, Aggregation> wrapInNestedElementAggregation(ExecutionContext<ProcessReportDataDto, ?> context, Pair<String, Aggregation> aggregationToWrap, Map<String, Aggregation> distributedBySubAggregations) {
        Aggregation filteredElementsAggregation = new Aggregation.Builder().filter(this.getFilterBoolQuery(context)).aggregations(MapUtil.createFromPair(aggregationToWrap)).build();
        Aggregation modelElementTypeFilterAggregation = new Aggregation.Builder().filter(this.getModelElementTypeFilterQuery()).aggregations(MapUtil.combineUniqueMaps(Map.of(FILTERED_ELEMENTS_AGGREGATION, filteredElementsAggregation), distributedBySubAggregations)).build();
        Aggregation aggregation = new Aggregation.Builder().nested(n -> n.path(this.getPathToElementField())).aggregations(MODEL_ELEMENT_TYPE_FILTER_AGGREGATION, modelElementTypeFilterAggregation).build();
        return Map.of(ELEMENT_AGGREGATION, aggregation);
    }

    private List<CompositeCommandResult.GroupByResult> processAggregations(SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Map aggregations = response.aggregations();
        if (aggregations == null || aggregations.isEmpty()) {
            return Collections.emptyList();
        }
        NestedAggregate flowNodes = ((Aggregate)aggregations.get(ELEMENT_AGGREGATION)).nested();
        FilterAggregate filteredFlowNodesByType = ((Aggregate)flowNodes.aggregations().get(MODEL_ELEMENT_TYPE_FILTER_AGGREGATION)).filter();
        FilterAggregate filteredFlowNodes = ((Aggregate)filteredFlowNodesByType.aggregations().get(FILTERED_ELEMENTS_AGGREGATION)).filter();
        Optional<Map<String, Aggregate>> maybeUnwrappedLimitedAggregations = FilterLimitedAggregationUtilOS.unwrapFilterLimitedAggregations(filteredFlowNodes.aggregations());
        this.getDistributedByInterpreter().enrichContextWithAllExpectedDistributedByKeys(context, filteredFlowNodesByType.aggregations());
        return maybeUnwrappedLimitedAggregations.map(unwrappedLimitedAggregations -> {
            Map<String, Map<String, Aggregate>> keyToAggregationMap = this.getDateAggregationService().mapDateAggregationsToKeyAggregationMap((Map<String, Aggregate>)unwrappedLimitedAggregations, context.getTimezone());
            return this.mapKeyToAggMapToGroupByResults(keyToAggregationMap, response, context);
        }).orElse(List.of());
    }

    private List<CompositeCommandResult.GroupByResult> mapKeyToAggMapToGroupByResults(Map<String, Map<String, Aggregate>> keyToAggregationMap, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return keyToAggregationMap.entrySet().stream().map(stringBucketEntry -> CompositeCommandResult.GroupByResult.createGroupByResult((String)stringBucketEntry.getKey(), this.getDistributedByInterpreter().retrieveResult(response, (Map)stringBucketEntry.getValue(), context))).collect(Collectors.toList());
    }

    private AggregateByDateUnit getGroupByDateUnit(ProcessReportDataDto processReportData) {
        return ((DateGroupByValueDto)processReportData.getGroupBy().getValue()).getUnit();
    }

    protected abstract String getDateField();

    protected abstract Query getFilterBoolQuery(ExecutionContext<ProcessReportDataDto, ?> var1);

    protected abstract Query getModelElementTypeFilterQuery();
}

