/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.model;

import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.FlowNodeDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.AbstractProcessDistributedByInterpreterOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.distributedby.process.model.ProcessDistributedByModelElementInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;

public abstract class AbstractProcessDistributedByModelElementInterpreterOS
extends AbstractProcessDistributedByInterpreterOS {
    private static final String MODEL_ELEMENT_ID_TERMS_AGGREGATION = "modelElement";

    protected abstract ConfigurationService getConfigurationService();

    protected abstract DefinitionService getDefinitionService();

    protected abstract ProcessDistributedByModelElementInterpreterHelper getHelper();

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        TermsAggregation termsAggregation = new TermsAggregation.Builder().size(this.getConfigurationService().getOpenSearchConfiguration().getAggregationBucketLimit()).order(Map.of("_key", SortOrder.Asc), new Map[0]).field(this.getModelElementIdPath()).build();
        Aggregation aggregation = new Aggregation.Builder().terms(termsAggregation).aggregations(this.getViewInterpreter().createAggregations(context)).build();
        return Map.of(MODEL_ELEMENT_ID_TERMS_AGGREGATION, aggregation);
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        StringTermsAggregate byModelElementAggregation = aggregations.get(MODEL_ELEMENT_ID_TERMS_AGGREGATION).sterms();
        Map<String, FlowNodeDataDto> modelElementData = this.getHelper().getModelElementData(context.getReportData(), this::extractModelElementData);
        ArrayList<CompositeCommandResult.DistributedByResult> distributedByModelElements = new ArrayList<CompositeCommandResult.DistributedByResult>();
        for (StringTermsBucket modelElementBucket : byModelElementAggregation.buckets().array()) {
            CompositeCommandResult.ViewResult viewResult = this.getViewInterpreter().retrieveResult(response, modelElementBucket.aggregations(), context);
            String modelElementKey = modelElementBucket.key();
            if (!modelElementData.containsKey(modelElementKey)) continue;
            String label = modelElementData.get(modelElementKey).getName();
            distributedByModelElements.add(CompositeCommandResult.DistributedByResult.createDistributedByResult(modelElementKey, label, viewResult));
            modelElementData.remove(modelElementKey);
        }
        distributedByModelElements.addAll(this.getHelper().missingDistributions(modelElementData, this.getViewInterpreter(), context));
        return distributedByModelElements;
    }

    protected abstract String getModelElementIdPath();

    protected abstract Map<String, FlowNodeDataDto> extractModelElementData(DefinitionOptimizeResponseDto var1);
}

