/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter.util;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.util.DefinitionQueryUtilOS;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import java.util.List;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;

public class NestedDefinitionQueryBuilderOS {
    private final String nestedField;
    private final String definitionKeyField;
    private final String versionField;
    private final String tenantIdField;

    public NestedDefinitionQueryBuilderOS(String nestedField, String definitionKeyField, String versionField, String tenantIdField) {
        this.nestedField = nestedField;
        this.definitionKeyField = definitionKeyField;
        this.versionField = versionField;
        this.tenantIdField = tenantIdField;
    }

    public BoolQuery.Builder createNestedDocDefinitionQuery(String definitionKey, List<String> definitionVersions, List<String> tenantIds, DefinitionService definitionService) {
        BoolQuery.Builder queryBuilder = new BoolQuery.Builder();
        queryBuilder.filter(DefinitionQueryUtilOS.createTenantIdQuery(this.nestedFieldReference(this.tenantIdField), tenantIds), new Query[0]);
        queryBuilder.filter(QueryDSL.term((String)this.nestedFieldReference(this.definitionKeyField), (String)definitionKey), new Query[0]);
        if (DefinitionVersionHandlingUtil.isDefinitionVersionSetToLatest(definitionVersions)) {
            queryBuilder.filter(QueryDSL.term((String)this.nestedFieldReference(this.versionField), (String)definitionService.getLatestVersionToKey(DefinitionType.PROCESS, definitionKey)), new Query[0]);
        } else if (!DefinitionVersionHandlingUtil.isDefinitionVersionSetToAll(definitionVersions)) {
            queryBuilder.filter(QueryDSL.stringTerms((String)this.nestedFieldReference(this.versionField), definitionVersions), new Query[0]);
        } else if (definitionVersions.isEmpty()) {
            queryBuilder.mustNot(QueryDSL.matchAll(), new Query[0]);
        }
        return queryBuilder;
    }

    private String nestedFieldReference(String fieldName) {
        return this.nestedField + "." + fieldName;
    }
}

