/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter.util;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.RelativeDateFilterStartDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.RollingDateFilterStartDto;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.DateFilterUtil;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateFilterQueryUtilOS {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final Logger LOG = LoggerFactory.getLogger(DateFilterQueryUtilOS.class);

    private DateFilterQueryUtilOS() {
    }

    public static List<Query> filterQueries(List<DateFilterDataDto<?>> dates, String dateField, ZoneId timezone) {
        return dates == null ? List.of() : dates.stream().flatMap(dateDto -> DateFilterQueryUtilOS.createRangeQuery(dateDto, dateField, timezone).stream()).toList();
    }

    public static List<Query> createRangeQueries(List<DateFilterDataDto<?>> dates, String dateField, ZoneId timezone) {
        return dates == null ? List.of() : dates.stream().flatMap(dateDto -> DateFilterQueryUtilOS.createRangeQuery(dateDto, dateField, timezone).stream()).toList();
    }

    public static Optional<Query> createRangeQuery(DateFilterDataDto<?> dateFilterDto, String dateField, ZoneId timezone) {
        switch (dateFilterDto.getType()) {
            case FIXED: {
                return DateFilterQueryUtilOS.createFixedDateFilter((OffsetDateTime)dateFilterDto.getStart(), dateFilterDto.getEnd(), dateField, timezone);
            }
            case ROLLING: {
                return DateFilterQueryUtilOS.createRollingDateFilter((RollingDateFilterStartDto)dateFilterDto.getStart(), dateField, timezone);
            }
            case RELATIVE: {
                return DateFilterQueryUtilOS.createRelativeDateFilter((RelativeDateFilterStartDto)dateFilterDto.getStart(), dateField, timezone);
            }
        }
        LOG.warn("Cannot execute date filter. Unknown type [{}]", (Object)dateFilterDto.getType());
        return Optional.empty();
    }

    private static Optional<Query> createFixedDateFilter(OffsetDateTime start, OffsetDateTime end, String dateField, ZoneId timezone) {
        if (end == null && start == null) {
            return Optional.empty();
        }
        RangeQuery.Builder rangeQueryBuilder = new RangeQuery.Builder().field(dateField);
        if (end != null) {
            OffsetDateTime endDateWithCorrectTimezone = end.atZoneSameInstant(timezone).toOffsetDateTime();
            rangeQueryBuilder.lte(QueryDSL.json((Object)FORMATTER.format(endDateWithCorrectTimezone)));
        }
        if (start != null) {
            OffsetDateTime startDateWithCorrectTimezone = start.atZoneSameInstant(timezone).toOffsetDateTime();
            rangeQueryBuilder.gte(QueryDSL.json((Object)FORMATTER.format(startDateWithCorrectTimezone)));
        }
        rangeQueryBuilder.format("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return Optional.of(rangeQueryBuilder.build().toQuery());
    }

    private static Optional<Query> createRollingDateFilter(RollingDateFilterStartDto startDto, String dateField, ZoneId timezone) {
        if (startDto == null || startDto.getUnit() == null || startDto.getValue() == null) {
            return Optional.empty();
        }
        RangeQuery.Builder rangeQueryBuilder = new RangeQuery.Builder().field(dateField);
        OffsetDateTime now = LocalDateUtil.getCurrentTimeWithTimezone((ZoneId)timezone);
        rangeQueryBuilder.lte(QueryDSL.json((Object)FORMATTER.format(now)));
        if (DateUnit.QUARTERS.equals((Object)startDto.getUnit())) {
            LOG.warn("Cannot create date filter: {} is not supported for rolling date filters", (Object)startDto.getUnit());
            throw new OptimizeValidationException(String.format("%s is not supported for rolling date filters", startDto.getUnit()));
        }
        OffsetDateTime dateBeforeGivenFilter = now.minus(startDto.getValue(), ChronoUnit.valueOf(startDto.getUnit().getId().toUpperCase()));
        rangeQueryBuilder.gte(QueryDSL.json((Object)FORMATTER.format(dateBeforeGivenFilter)));
        rangeQueryBuilder.format("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return Optional.of(rangeQueryBuilder.build().toQuery());
    }

    private static Optional<Query> createRelativeDateFilter(RelativeDateFilterStartDto startDto, String dateField, ZoneId timezone) {
        if (startDto == null || startDto.getUnit() == null || startDto.getValue() == null) {
            return Optional.empty();
        }
        RangeQuery.Builder rangeQueryBuilder = new RangeQuery.Builder().field(dateField);
        OffsetDateTime now = LocalDateUtil.getCurrentTimeWithTimezone((ZoneId)timezone);
        if (startDto.getValue() == 0L) {
            rangeQueryBuilder.lte(QueryDSL.json((Object)FORMATTER.format(now)));
            rangeQueryBuilder.gte(QueryDSL.json((Object)FORMATTER.format(DateFilterUtil.getStartOfCurrentInterval(now, startDto.getUnit()))));
        } else {
            OffsetDateTime startOfCurrentInterval = DateFilterUtil.getStartOfCurrentInterval(now, startDto.getUnit());
            OffsetDateTime startOfPreviousInterval = DateFilterUtil.getStartOfPreviousInterval(startOfCurrentInterval, startDto.getUnit(), startDto.getValue());
            rangeQueryBuilder.lt(QueryDSL.json((Object)FORMATTER.format(startOfCurrentInterval)));
            rangeQueryBuilder.gte(QueryDSL.json((Object)FORMATTER.format(startOfPreviousInterval)));
        }
        rangeQueryBuilder.format("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return Optional.of(rangeQueryBuilder.build().toQuery());
    }
}

